/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio;

import com.almostreliable.kubeio.binding.DataComponents;
import com.almostreliable.kubeio.component.EnchantmentComponent;
import com.almostreliable.kubeio.component.FireCraftingResultComponent;
import com.almostreliable.kubeio.component.SagMillOutputItemComponent;
import com.almostreliable.kubeio.component.SimpleComponents;
import com.almostreliable.kubeio.event.ConduitRegistryEvent;
import com.almostreliable.kubeio.recipe.AlloySmelterKubeRecipe;
import com.almostreliable.kubeio.recipe.FireCraftingKubeRecipe;
import com.almostreliable.kubeio.recipe.TankKubeRecipe;
import com.almostreliable.kubeio.schema.AlloySmelterRecipeSchema;
import com.almostreliable.kubeio.schema.EnchanterRecipeSchema;
import com.almostreliable.kubeio.schema.FireCraftingRecipeSchema;
import com.almostreliable.kubeio.schema.PaintingRecipeSchema;
import com.almostreliable.kubeio.schema.SagMillRecipeSchema;
import com.almostreliable.kubeio.schema.SlicerRecipeSchema;
import com.almostreliable.kubeio.schema.SoulBinderRecipeSchema;
import com.almostreliable.kubeio.schema.TankRecipeSchema;
import com.almostreliable.kubeio.schema.VatRecipeSchema;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.base.common.recipe.FireCraftingRecipe;
import com.enderio.core.common.recipes.RecipeTypeSerializerPair;
import com.enderio.machines.common.blocks.fluid_tank.TankRecipe;
import com.enderio.machines.common.blocks.sag_mill.SagMillingRecipe;
import com.enderio.machines.common.init.MachineRecipes;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.generator.KubeDataGenerator;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentTypeRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;

public class KubePlugin
implements KubeJSPlugin {
    public static final Set<ResourceLocation> SMELTING_RECIPES = new HashSet<ResourceLocation>();

    public void registerEvents(EventGroupRegistry registry) {
        registry.register(Events.GROUP);
    }

    public void registerBindings(BindingRegistry registry) {
        if (registry.type().isServer()) {
            registry.add("FireCraftingResult", FireCraftingRecipe.Result.class);
            registry.add("MobCategory", MobCategory.class);
            registry.add("SagMillBonus", SagMillingRecipe.BonusType.class);
            registry.add("SagMillOutput", SagMillingRecipe.OutputItem.class);
            registry.add("TankMode", TankRecipe.Mode.class);
        }
        if (registry.type().isStartup()) {
            registry.add("EnderIOComponents", DataComponents.class);
        }
    }

    public void registerRecipeComponents(RecipeComponentTypeRegistry registry) {
        registry.register(SimpleComponents.BOUS_TYPE);
        registry.register(SimpleComponents.MOB_CATEGORY);
        registry.register(SimpleComponents.TANK_MODE);
        registry.register(EnchantmentComponent.TYPE);
        registry.register(FireCraftingResultComponent.TYPE);
        registry.register(SagMillOutputItemComponent.TYPE);
    }

    public void registerRecipeFactories(RecipeFactoryRegistry registry) {
        registry.register(AlloySmelterKubeRecipe.FACTORY);
        registry.register(FireCraftingKubeRecipe.FACTORY);
        registry.register(TankKubeRecipe.FACTORY);
    }

    public void registerRecipeSchemas(RecipeSchemaRegistry registry) {
        Map<RecipeTypeSerializerPair, RecipeSchema> basicRecipeSchemas = Map.of(EIORecipes.FIRE_CRAFTING, FireCraftingRecipeSchema.SCHEMA);
        Map<RecipeTypeSerializerPair, RecipeSchema> machineRecipeSchemas = Map.of(MachineRecipes.ALLOY_SMELTING, AlloySmelterRecipeSchema.SCHEMA, MachineRecipes.ENCHANTING, EnchanterRecipeSchema.SCHEMA, MachineRecipes.PAINTING, PaintingRecipeSchema.SCHEMA, MachineRecipes.SAG_MILLING, SagMillRecipeSchema.SCHEMA, MachineRecipes.SLICING, SlicerRecipeSchema.SCHEMA, MachineRecipes.SOUL_BINDING, SoulBinderRecipeSchema.SCHEMA, MachineRecipes.TANK, TankRecipeSchema.SCHEMA, MachineRecipes.VAT_FERMENTING, VatRecipeSchema.SCHEMA);
        RecipeNamespace namespace = registry.namespace("enderio");
        for (Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> entry : basicRecipeSchemas.entrySet()) {
            this.registerRecipeSchema(namespace, entry);
        }
        for (Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> entry : machineRecipeSchemas.entrySet()) {
            this.registerRecipeSchema(namespace, entry);
        }
    }

    public void generateData(KubeDataGenerator generator) {
        Events.CONDUIT_REGISTRY.post((KubeEvent)new ConduitRegistryEvent());
        ConduitRegistryEvent.CUSTOM_CONDUITS.forEach((arg_0, arg_1) -> ((KubeDataGenerator)generator).json(arg_0, arg_1));
        ConduitRegistryEvent.clear();
    }

    private void registerRecipeSchema(RecipeNamespace namespace, Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> schemaEntry) {
        String id = schemaEntry.getKey().type().getId().getPath();
        namespace.register(id, schemaEntry.getValue());
    }

    public static interface Events {
        public static final EventGroup GROUP = EventGroup.of((String)"EnderIOEvents");
        public static final EventHandler CONDUIT_REGISTRY = GROUP.server("conduits", () -> ConduitRegistryEvent.class);
    }
}

