/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.kubejspowah;

import com.bobvarioa.kubejspowah.EnergizingOrbRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.generator.KubeDataGenerator;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class KubeJSPowahPlugin
implements KubeJSPlugin {
    public static EventGroup GROUP = EventGroup.of((String)"PowahEvents");
    public static EventHandler COOLANTS = GROUP.server("registerCoolants", () -> CoolantsEvent.class);
    public static EventHandler HEAT_SOURCE = GROUP.server("registerHeatSource", () -> HeatSourceEvent.class);
    public static EventHandler MAGMATIC_FLUID = GROUP.server("registerMagmaticFluid", () -> MagmaticFluidEvent.class);
    public static EventHandler REACTOR_FUEL = GROUP.server("registerReactorFuel", () -> ReactorFuelEvent.class);

    public void registerRecipeSchemas(RecipeSchemaRegistry registry) {
        registry.register(ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"energizing"), EnergizingOrbRecipe.SCHEMA);
    }

    public void registerEvents(EventGroupRegistry registry) {
        registry.register(GROUP);
    }

    public void init() {
    }

    private JsonObject toObj(Map<ResourceLocation, Integer> map, String key, List<ResourceLocation> removals) {
        JsonObject res = new JsonObject();
        JsonObject values = new JsonObject();
        for (Map.Entry<ResourceLocation, Integer> entries : map.entrySet()) {
            JsonObject sub = new JsonObject();
            sub.addProperty("replace", Boolean.valueOf(true));
            JsonObject obj = new JsonObject();
            obj.addProperty(key, (Number)entries.getValue());
            sub.add("value", (JsonElement)obj);
            values.add(entries.getKey().toString(), (JsonElement)sub);
        }
        res.add("values", (JsonElement)values);
        JsonArray removed = new JsonArray();
        for (ResourceLocation item : removals) {
            removed.add(item.toString());
        }
        res.add("remove", (JsonElement)removed);
        return res;
    }

    private JsonObject toObj(Map<ResourceLocation, Pair<Integer, Integer>> map, String key, String key2, List<ResourceLocation> removals) {
        JsonObject res = new JsonObject();
        JsonObject values = new JsonObject();
        for (Map.Entry<ResourceLocation, Pair<Integer, Integer>> entries : map.entrySet()) {
            JsonObject sub = new JsonObject();
            sub.addProperty("replace", Boolean.valueOf(true));
            JsonObject obj = new JsonObject();
            obj.addProperty(key, (Number)entries.getValue().left());
            obj.addProperty(key2, (Number)entries.getValue().right());
            sub.add("value", (JsonElement)obj);
            values.add(entries.getKey().toString(), (JsonElement)sub);
        }
        res.add("values", (JsonElement)values);
        JsonArray removed = new JsonArray();
        for (ResourceLocation item : removals) {
            removed.add(item.toString());
        }
        res.add("remove", (JsonElement)removed);
        return res;
    }

    public void generateData(KubeDataGenerator generator) {
        KubeJSPowahPlugin.clear();
        COOLANTS.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)CoolantsEvent.INSTANCE);
        HEAT_SOURCE.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)HeatSourceEvent.INSTANCE);
        MAGMATIC_FLUID.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)MagmaticFluidEvent.INSTANCE);
        REACTOR_FUEL.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)ReactorFuelEvent.INSTANCE);
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/block/heat_source"), () -> this.toObj(HeatSourceEvent.addedBlocks, "temperature", HeatSourceEvent.removedBlocks)));
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/fluid/heat_source"), () -> this.toObj(HeatSourceEvent.addedFluids, "temperature", HeatSourceEvent.removedFluids)));
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/fluid/fluid_coolant"), () -> this.toObj(CoolantsEvent.addedFluids, "temperature", CoolantsEvent.removedFluids)));
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/fluid/magmator_fuel"), () -> this.toObj(MagmaticFluidEvent.addedFluids, "energy_produced", MagmaticFluidEvent.removedFluids)));
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/item/solid_coolant"), () -> this.toObj(CoolantsEvent.addedItems, "amount", "temperature", CoolantsEvent.removedItems)));
        generator.add(GeneratedData.json((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"data_maps/item/reactor_fuel"), () -> this.toObj(ReactorFuelEvent.addedItems, "fuelAmount", "temperature", ReactorFuelEvent.removedItems)));
    }

    public static void clear() {
        CoolantsEvent.addedFluids.clear();
        CoolantsEvent.addedItems.clear();
        HeatSourceEvent.addedBlocks.clear();
        HeatSourceEvent.addedFluids.clear();
        MagmaticFluidEvent.addedFluids.clear();
        ReactorFuelEvent.addedItems.clear();
    }

    public static class CoolantsEvent
    implements KubeEvent {
        public static CoolantsEvent INSTANCE = new CoolantsEvent();
        private static Map<ResourceLocation, Integer> addedFluids = new LinkedHashMap<ResourceLocation, Integer>();
        private static Map<ResourceLocation, Pair<Integer, Integer>> addedItems = new LinkedHashMap<ResourceLocation, Pair<Integer, Integer>>();
        private static List<ResourceLocation> removedFluids = new ArrayList<ResourceLocation>();
        private static List<ResourceLocation> removedItems = new ArrayList<ResourceLocation>();

        public void addFluid(ResourceLocation res, int cool) {
            addedFluids.put(res, cool);
        }

        public void addSolid(ItemStack res, int cool) {
            addedItems.put(BuiltInRegistries.ITEM.getKey((Object)res.getItem()), (Pair<Integer, Integer>)Pair.of((Object)res.getCount(), (Object)cool));
        }

        public void removeFluid(ResourceLocation fluid) {
            removedFluids.add(fluid);
        }

        public void removeSolid(ResourceLocation solid) {
            removedItems.add(solid);
        }
    }

    public static class HeatSourceEvent
    implements KubeEvent {
        public static HeatSourceEvent INSTANCE = new HeatSourceEvent();
        private static Map<ResourceLocation, Integer> addedBlocks = new LinkedHashMap<ResourceLocation, Integer>();
        private static Map<ResourceLocation, Integer> addedFluids = new LinkedHashMap<ResourceLocation, Integer>();
        private static List<ResourceLocation> removedBlocks = new ArrayList<ResourceLocation>();
        private static List<ResourceLocation> removedFluids = new ArrayList<ResourceLocation>();

        public void addBlock(ResourceLocation res, int heat) {
            addedBlocks.put(res, heat);
        }

        public void addFluid(ResourceLocation res, int heat) {
            addedFluids.put(res, heat);
        }

        public void removeBlock(ResourceLocation block) {
            removedBlocks.add(block);
        }

        public void removeFluid(ResourceLocation solid) {
            removedFluids.add(solid);
        }
    }

    public static class MagmaticFluidEvent
    implements KubeEvent {
        public static MagmaticFluidEvent INSTANCE = new MagmaticFluidEvent();
        private static Map<ResourceLocation, Integer> addedFluids = new LinkedHashMap<ResourceLocation, Integer>();
        private static List<ResourceLocation> removedFluids = new ArrayList<ResourceLocation>();

        public void add(ResourceLocation res, int heat) {
            addedFluids.put(res, heat);
        }

        public void remove(ResourceLocation fluid) {
            removedFluids.add(fluid);
        }
    }

    public static class ReactorFuelEvent
    implements KubeEvent {
        public static ReactorFuelEvent INSTANCE = new ReactorFuelEvent();
        private static Map<ResourceLocation, Pair<Integer, Integer>> addedItems = new LinkedHashMap<ResourceLocation, Pair<Integer, Integer>>();
        private static List<ResourceLocation> removedItems = new ArrayList<ResourceLocation>();

        public void add(ItemStack res, int heat) {
            addedItems.put(BuiltInRegistries.ITEM.getKey((Object)res.getItem()), (Pair<Integer, Integer>)Pair.of((Object)res.getCount(), (Object)heat));
        }

        public void remove(ResourceLocation item) {
            removedItems.add(item);
        }
    }
}

