/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.fml.ModList;

public class CodecScanner {
    public static final Map<Object, Field> codecFields = new HashMap<Object, Field>();

    public static void scanVanilla() {
        ModList.get().getAllScanData().forEach(scanData -> scanData.getClasses().forEach(clazz -> {
            String clazzname = clazz.clazz().getClassName();
            try {
                Class<?> realClazz = Class.forName(clazzname);
                Arrays.stream(realClazz.getDeclaredFields()).filter(field -> field.getType() != Object.class && Modifier.isStatic(field.getModifiers()) && (Codec.class.isAssignableFrom(field.getType()) || MapCodec.class.isAssignableFrom(field.getType()))).forEach(CodecScanner::fieldToObject);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }));
        Arrays.stream(Codec.class.getDeclaredFields()).filter(field -> field.getType() != Object.class && Modifier.isStatic(field.getModifiers()) && (Codec.class.isAssignableFrom(field.getType()) || MapCodec.class.isAssignableFrom(field.getType()))).forEach(CodecScanner::fieldToObject);
        KubeJSTweaks.LOGGER.info("Found {} codecs", (Object)codecFields.size());
    }

    private static void fieldToObject(Field field) {
        try {
            field.setAccessible(true);
            Object obj = field.get(null);
            if (obj == null) {
                return;
            }
            codecFields.put(obj, field);
            if (obj instanceof MapCodec) {
                MapCodec mapCodec = (MapCodec)obj;
                codecFields.put(mapCodec.codec(), field);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

