/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.setup;

import com.direwolf20.laserio.client.blockentityrenders.LaserConnectorAdvBERender;
import com.direwolf20.laserio.client.blockentityrenders.LaserConnectorBERender;
import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.client.events.ClientEvents;
import com.direwolf20.laserio.client.events.EventTooltip;
import com.direwolf20.laserio.client.screens.CardChemicalScreen;
import com.direwolf20.laserio.client.screens.CardEnergyScreen;
import com.direwolf20.laserio.client.screens.CardFluidScreen;
import com.direwolf20.laserio.client.screens.CardHolderScreen;
import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.CardRedstoneScreen;
import com.direwolf20.laserio.client.screens.FilterBasicScreen;
import com.direwolf20.laserio.client.screens.FilterCountScreen;
import com.direwolf20.laserio.client.screens.FilterNBTScreen;
import com.direwolf20.laserio.client.screens.FilterTagScreen;
import com.direwolf20.laserio.client.screens.LaserNodeScreen;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserConnectorBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.setup.Registration;
import java.awt.Color;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="laserio", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.LaserNode.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.LaserConnector.get()), (RenderType)RenderType.cutout());
        NeoForge.EVENT_BUS.register(ClientEvents.class);
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)Registration.Card_Item.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack)));
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)Registration.Card_Fluid.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack)));
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)Registration.Card_Energy.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack)));
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)Registration.Card_Redstone.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"mode"), (stack, level, living, id) -> CardRedstone.getTransferMode(stack)));
        if (MekanismIntegration.isLoaded()) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)Registration.Card_Chemical.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"mode"), (stack, level, living, id) -> CardChemical.getTransferMode(stack)));
        }
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)Registration.LaserNode_Container.get(), LaserNodeScreen::new);
        event.register((MenuType)Registration.CardItem_Container.get(), CardItemScreen::new);
        event.register((MenuType)Registration.CardFluid_Container.get(), CardFluidScreen::new);
        event.register((MenuType)Registration.CardEnergy_Container.get(), CardEnergyScreen::new);
        event.register((MenuType)Registration.CardRedstone_Container.get(), CardRedstoneScreen::new);
        event.register((MenuType)Registration.CardChemical_Container.get(), CardChemicalScreen::new);
        event.register((MenuType)Registration.CardHolder_Container.get(), CardHolderScreen::new);
        event.register((MenuType)Registration.FilterBasic_Container.get(), FilterBasicScreen::new);
        event.register((MenuType)Registration.FilterCount_Container.get(), FilterCountScreen::new);
        event.register((MenuType)Registration.FilterTag_Container.get(), FilterTagScreen::new);
        event.register((MenuType)Registration.FilterNBT_Container.get(), FilterNBTScreen::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LaserConnector_BE.get(), LaserConnectorBERender::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LaserNode_BE.get(), LaserNodeBERender::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LaserConnectorAdv_BE.get(), LaserConnectorAdvBERender::new);
    }

    @SubscribeEvent
    public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(EventTooltip.CopyPasteTooltipComponent.Data.class, EventTooltip.CopyPasteTooltipComponent::new);
    }

    @SubscribeEvent
    static void itemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.register((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getTransferMode(stack) == 3) {
                    Color color = LaserNodeBERender.colors[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.colors[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.Card_Item.get()});
        colors.register((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getTransferMode(stack) == 3) {
                    Color color = LaserNodeBERender.colors[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.colors[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.Card_Fluid.get()});
        if (MekanismIntegration.isLoaded()) {
            colors.register((stack, index) -> {
                if (index == 2) {
                    if (BaseCard.getTransferMode(stack) == 3) {
                        Color color = LaserNodeBERender.colors[BaseCard.getRedstoneChannel(stack)];
                        return color.getRGB();
                    }
                    Color color = LaserNodeBERender.colors[BaseCard.getChannel(stack)];
                    return color.getRGB();
                }
                return -1;
            }, new ItemLike[]{(ItemLike)Registration.Card_Chemical.get()});
        }
        colors.register((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getTransferMode(stack) == 3) {
                    Color color = LaserNodeBERender.colors[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.colors[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.Card_Energy.get()});
        colors.register((stack, index) -> {
            if (index == 2) {
                Color color = LaserNodeBERender.colors[CardRedstone.getRedstoneChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.Card_Redstone.get()});
        colors.register((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LaserNode_ITEM.get()});
        colors.register((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LaserConnector_ITEM.get()});
        colors.register((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LaserConnectorAdv_ITEM.get()});
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, env, pos, index) -> {
            assert (env != null);
            assert (pos != null);
            BlockEntity patt0$temp = env.getBlockEntity(pos);
            if (patt0$temp instanceof LaserNodeBE) {
                LaserNodeBE laserNodeBE = (LaserNodeBE)patt0$temp;
                Color color = laserNodeBE.getColor();
                return FastColor.ARGB32.color((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LaserNode.get()});
        event.register((state, env, pos, index) -> {
            assert (env != null);
            assert (pos != null);
            BlockEntity patt0$temp = env.getBlockEntity(pos);
            if (patt0$temp instanceof LaserConnectorBE) {
                LaserConnectorBE laserConnectorBE = (LaserConnectorBE)patt0$temp;
                Color color = laserConnectorBE.getColor();
                return FastColor.ARGB32.color((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LaserConnector.get()});
        event.register((state, env, pos, index) -> {
            assert (env != null);
            assert (pos != null);
            BlockEntity patt0$temp = env.getBlockEntity(pos);
            if (patt0$temp instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)patt0$temp;
                Color color = laserConnectorAdvBE.getColor();
                return FastColor.ARGB32.color((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LaserConnectorAdv.get()});
    }
}

