/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.util.MiscTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class CardRender {
    public Direction direction;
    public int cardSlot;
    public float r;
    public float g;
    public float b;
    public BlockPos startBlock;
    public BlockPos endBlock;
    public float diffX;
    public float diffY;
    public float diffZ;
    public Vector3f startLaser;
    public Vector3f endLaser;
    public float[] floatcolors;

    public CardRender(Direction direction, int cardSlot, ItemStack card, BlockPos start, Level level, boolean enabled) {
        boolean reverse;
        this.direction = direction;
        this.cardSlot = cardSlot;
        this.startBlock = start;
        this.endBlock = this.startBlock.relative(direction);
        BlockState targetState = level.getBlockState(this.endBlock);
        VoxelShape voxelShape = targetState.getShape((BlockGetter)level, this.endBlock);
        if (((BaseCard)card.getItem()).getCardType() == BaseCard.CardType.ITEM) {
            this.r = 0.0f;
            this.g = 1.0f;
            this.b = 0.0f;
        } else if (((BaseCard)card.getItem()).getCardType() == BaseCard.CardType.FLUID) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 1.0f;
        } else if (((BaseCard)card.getItem()).getCardType() == BaseCard.CardType.ENERGY) {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 0.0f;
        } else if (((BaseCard)card.getItem()).getCardType() == BaseCard.CardType.REDSTONE) {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 0.0f;
        } else if (((BaseCard)card.getItem()).getCardType() == BaseCard.CardType.CHEMICAL) {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 1.0f;
        }
        if (!enabled) {
            this.r /= 4.0f;
            this.g /= 4.0f;
            this.b /= 4.0f;
        }
        Vector3f offset = MiscTools.findOffset(direction, cardSlot, LaserNodeBERender.offsets);
        Vector3f shapeOffset = CardRender.shapeOffset(offset, voxelShape, this.startBlock, this.endBlock, direction, level, targetState);
        this.diffX = shapeOffset.x();
        this.diffY = shapeOffset.y();
        this.diffZ = shapeOffset.z();
        boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
        if (card.getItem() instanceof CardRedstone) {
            if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.INSERT) {
                reverse = !reverse;
            }
        } else if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
            reverse = !reverse;
        }
        this.floatcolors = card.getItem() instanceof CardRedstone || BaseCard.getNamedTransferMode(card) == BaseCard.TransferMode.SENSOR ? LaserNodeBERender.colors[BaseCard.getRedstoneChannel(card)].getColorComponents(new float[3]) : LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
        if (reverse) {
            this.endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            this.startLaser = new Vector3f(this.diffX, this.diffY, this.diffZ);
        } else {
            this.startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            this.endLaser = new Vector3f(this.diffX, this.diffY, this.diffZ);
        }
    }

    public static Vector3f shapeOffset(Vector3f offset, VoxelShape voxelShape, BlockPos startBlock, BlockPos endBlock, Direction direction, Level level, BlockState targetState) {
        float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
        float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
        float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
        if (!voxelShape.isEmpty()) {
            diffX = (float)((voxelShape.bounds().maxX - voxelShape.bounds().minX) * (double)diffX + voxelShape.bounds().minX);
            diffY = (float)((voxelShape.bounds().maxY - voxelShape.bounds().minY) * (double)diffY + voxelShape.bounds().minY);
            diffZ = (float)((voxelShape.bounds().maxZ - voxelShape.bounds().minZ) * (double)diffZ + voxelShape.bounds().minZ);
            if (direction.equals((Object)Direction.WEST)) {
                diffX = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).x != 0.0 ? -1.0f - (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).x + 0.0625 - (voxelShape.bounds().maxX - voxelShape.bounds().minX)) : -1.0f + (float)voxelShape.bounds().maxX;
                offset.x = offset.x() - 0.1875f;
            } else if (direction.equals((Object)Direction.EAST)) {
                diffX = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).x != 0.0 ? 1.0f + (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).x - 0.0625 + (voxelShape.bounds().maxX - voxelShape.bounds().minX)) : 1.0f + (float)voxelShape.bounds().minX;
                offset.x = offset.x() + 0.1875f;
            } else if (direction.equals((Object)Direction.SOUTH)) {
                diffZ = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).z != 0.0 ? 1.0f + (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).z - 0.0625 + (voxelShape.bounds().maxZ - voxelShape.bounds().minZ)) : 1.0f + (float)voxelShape.bounds().minZ;
                offset.z = offset.z() + 0.1875f;
            } else if (direction.equals((Object)Direction.NORTH)) {
                diffZ = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).z != 0.0 ? (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).z + 0.0625 - (voxelShape.bounds().maxZ - voxelShape.bounds().minZ)) : -1.0f + (float)voxelShape.bounds().maxZ;
                offset.z = offset.z() - 0.1875f;
            } else if (direction.equals((Object)Direction.UP)) {
                diffY = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).y != 0.0 ? 1.0f + (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).y - 0.0625 + (voxelShape.bounds().maxY - voxelShape.bounds().minY)) : 1.0f + (float)voxelShape.bounds().minY;
                offset.y = offset.y() + 0.1875f;
            } else if (direction.equals((Object)Direction.DOWN)) {
                diffY = targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).y != 0.0 ? (float)(targetState.getOffset((BlockGetter)level, (BlockPos)endBlock).y + 0.0625 - (voxelShape.bounds().maxY - voxelShape.bounds().minY)) : -1.0f + (float)voxelShape.bounds().maxY;
                offset.y = offset.y() - 0.1875f;
            }
        }
        return new Vector3f(diffX, diffY, diffZ);
    }
}

