/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.data;

import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;

public class Leaderboard {
    public final ResourceLocation id;
    private final Component title;
    private final Function<PlayerStatsWrapper, Component> playerToValue;
    private final Comparator<PlayerStatsWrapper> comparator;
    private final Predicate<PlayerStatsWrapper> validValue;

    public Leaderboard(ResourceLocation id, Component title, Function<PlayerStatsWrapper, Component> valueFunction, Comparator<PlayerStatsWrapper> comparator, Predicate<PlayerStatsWrapper> validValue) {
        this.id = id;
        this.title = title;
        this.playerToValue = valueFunction;
        this.comparator = comparator.thenComparing((p1, p2) -> p1.getGameProfile().getName().compareToIgnoreCase(p2.getGameProfile().getName()));
        this.validValue = validValue;
    }

    public Component getTitle() {
        return this.title;
    }

    public Comparator<PlayerStatsWrapper> getComparator() {
        return this.comparator;
    }

    public Component createValue(PlayerStatsWrapper player) {
        return this.playerToValue.apply(player);
    }

    public boolean hasValidValue(PlayerStatsWrapper player) {
        return this.validValue.test(player);
    }

    public static class FromStat
    extends Leaderboard {
        public static final IntFunction<Component> DEFAULT = value -> Component.literal((String)(value <= 0 ? "0" : Integer.toString(value)));
        public static final IntFunction<Component> TIME = value -> {
            if (value <= 0) {
                return Component.literal((String)"0");
            }
            int hours = (int)((double)value / 72000.0 + 0.5);
            int ticks = value % 24000;
            int seconds = ticks / 20;
            int minutes = seconds / 60;
            int displayHours = minutes / 60;
            return Component.literal((String)String.format("[%dh] %02d:%02d:%02d", hours, displayHours, minutes %= 60, seconds %= 60));
        };
        public static final IntFunction<Component> DISTANCE = value -> {
            if (value <= 0) {
                return Component.literal((String)"0");
            }
            double blocks = (double)value / 100.0;
            if (blocks >= 1000.0) {
                return Component.literal((String)String.format("%.2f km", blocks / 1000.0));
            }
            return Component.literal((String)String.format("%.1f m", blocks));
        };
        public static final IntFunction<Component> DAMAGE = value -> {
            if (value <= 0) {
                return Component.literal((String)"0");
            }
            double damage = (double)value / 10.0;
            return Component.literal((String)String.format("%.1f", damage));
        };

        public FromStat(ResourceLocation id, Component title, Stat<?> stat, boolean ascending, IntFunction<Component> valueFormatter) {
            super(id, title, (PlayerStatsWrapper player) -> (Component)valueFormatter.apply(player.getStats().getValue(stat)), (p1, p2) -> {
                int result = Integer.compare(p1.getStats().getValue(stat), p2.getStats().getValue(stat));
                return ascending ? result : -result;
            }, (PlayerStatsWrapper player) -> player.getStats().getValue(stat) > 0);
        }

        public FromStat(ResourceLocation id, Component title, Stat<?> stat, boolean ascending) {
            this(id, title, stat, ascending, DEFAULT);
        }
    }
}

