/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.gui;

import com.leclowndu93150.leaderboards.data.LeaderboardValue;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class LeaderboardScreen
extends ButtonListBaseScreen {
    private final List<LeaderboardValue> leaderboard;
    private int rankSize;
    private int usernameSize;
    private int valueSize;
    private int totalWidth;

    public LeaderboardScreen(Component title, List<LeaderboardValue> leaderboard) {
        this.setTitle((Component)Component.literal((String)(I18n.get((String)"sidebar_button.leaderboards.leaderboards", (Object[])new Object[0]) + " > " + title.getString())));
        this.setHasSearchBox(true);
        this.leaderboard = leaderboard;
    }

    public void alignWidgets() {
        if (this.totalWidth > 0) {
            int padding = 40;
            int scrollbarWidth = 16;
            int gutterSize = 6;
            int maxWidth = Math.min(this.totalWidth + padding, 400);
            int height = Math.min(this.leaderboard.size() * 15 + 40, 300);
            this.setWidth(maxWidth + scrollbarWidth + gutterSize * 3);
            this.setHeight(height + (this.hasSearchBox() ? 30 : 0));
        }
        super.alignWidgets();
    }

    private boolean hasSearchBox() {
        return true;
    }

    public void addButtons(Panel panel) {
        int i = 0;
        this.rankSize = 0;
        this.usernameSize = 0;
        this.valueSize = 0;
        for (LeaderboardValue value : this.leaderboard) {
            value.rank = ++i;
            panel.add((Widget)new LeaderboardEntry(panel, value));
        }
        this.totalWidth = this.rankSize + this.usernameSize + this.valueSize;
        this.setBorder(3, 1, 1);
    }

    public String getFilterText(Widget widget) {
        return ((LeaderboardEntry)widget).value.username.toLowerCase();
    }

    private class LeaderboardEntry
    extends Widget {
        private final LeaderboardValue value;
        private final String rank;

        public LeaderboardEntry(Panel panel, LeaderboardValue v) {
            super(panel);
            this.value = v;
            this.rank = String.valueOf(this.value.color) + "#" + String.format("%0" + String.valueOf(LeaderboardScreen.this.leaderboard.size()).length() + "d", v.rank);
            Theme theme = this.getGui().getTheme();
            LeaderboardScreen.this.rankSize = Math.max(LeaderboardScreen.this.rankSize, theme.getStringWidth(this.rank) + 4);
            LeaderboardScreen.this.usernameSize = Math.max(LeaderboardScreen.this.usernameSize, theme.getStringWidth(v.username) + 8);
            LeaderboardScreen.this.valueSize = Math.max(LeaderboardScreen.this.valueSize, theme.getStringWidth(this.value.value.getString()) + 8);
            this.setWidth(LeaderboardScreen.this.rankSize + LeaderboardScreen.this.usernameSize + LeaderboardScreen.this.valueSize);
            this.setHeight(14);
        }

        public void addMouseOverText(TooltipList list) {
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            WidgetType type = this.value.color == ChatFormatting.DARK_GRAY ? WidgetType.DISABLED : WidgetType.mouseOver((boolean)this.isMouseOver());
            int textY = y + (h - theme.getFontHeight() + 1) / 2;
            theme.drawButton(graphics, x, y, LeaderboardScreen.this.rankSize, h, type);
            theme.drawString(graphics, (Object)this.rank, x + 2, textY, 2);
            theme.drawButton(graphics, x + LeaderboardScreen.this.rankSize, y, LeaderboardScreen.this.usernameSize, h, type);
            theme.drawString(graphics, (Object)(String.valueOf(this.value.color) + this.value.username), x + 4 + LeaderboardScreen.this.rankSize, textY, 2);
            int remainingWidth = w - LeaderboardScreen.this.rankSize - LeaderboardScreen.this.usernameSize;
            theme.drawButton(graphics, x + LeaderboardScreen.this.rankSize + LeaderboardScreen.this.usernameSize, y, remainingWidth, h, type);
            String formattedText = this.value.value.getString();
            theme.drawString(graphics, (Object)(String.valueOf(this.value.color) + formattedText), x + LeaderboardScreen.this.rankSize + LeaderboardScreen.this.usernameSize + remainingWidth - theme.getStringWidth(formattedText) - 4, textY, 2);
        }
    }
}

