/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.gui.LeaderboardListScreen;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LeaderboardListResponsePacket(Map<ResourceLocation, Component> leaderboards) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LeaderboardListResponsePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"leaderboard_list_response"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LeaderboardListResponsePacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LeaderboardListResponsePacket>(){

        public LeaderboardListResponsePacket decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            LinkedHashMap<ResourceLocation, Component> map = new LinkedHashMap<ResourceLocation, Component>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buf.readResourceLocation();
                Component title = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
                map.put(id, title);
            }
            return new LeaderboardListResponsePacket(map);
        }

        public void encode(RegistryFriendlyByteBuf buf, LeaderboardListResponsePacket packet) {
            buf.writeVarInt(packet.leaderboards.size());
            for (Map.Entry<ResourceLocation, Component> entry : packet.leaderboards.entrySet()) {
                buf.writeResourceLocation(entry.getKey());
                ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)entry.getValue());
            }
        }
    };

    public static LeaderboardListResponsePacket fromLeaderboards(Map<ResourceLocation, Leaderboard> leaderboards) {
        LinkedHashMap<ResourceLocation, Component> map = new LinkedHashMap<ResourceLocation, Component>();
        for (Map.Entry<ResourceLocation, Leaderboard> entry : leaderboards.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getTitle());
        }
        return new LeaderboardListResponsePacket(map);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(LeaderboardListResponsePacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> Minecraft.getInstance().execute(() -> {
                LeaderboardListScreen screen = new LeaderboardListScreen(packet.leaderboards);
                screen.openGui();
            }));
        }
    }
}

