/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.buffer.LodestoneRenderLayer;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class LodestoneRenderHandler {
    public static RenderTarget LODESTONE_DEPTH_CACHE;
    public static LodestoneRenderLayer DEFERRED_RENDER;
    public static LodestoneRenderLayer LATE_DEFERRED_RENDER;
    public static Matrix4f MODEL_VIEW;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;
    public static FogShape FOG_SHAPE;

    public static void resize(int width, int height) {
        if (LODESTONE_DEPTH_CACHE != null) {
            LODESTONE_DEPTH_CACHE.resize(width, height, Minecraft.ON_OSX);
        }
    }

    public static void render() {
        LodestoneRenderHandler.copyDepthBuffer(LODESTONE_DEPTH_CACHE);
        LodestoneRenderHandler.applyCachedFogData();
        DEFERRED_RENDER.endBatches();
        LATE_DEFERRED_RENDER.endBatches();
        LodestoneRenderHandler.restoreFogData();
    }

    public static void cacheModelViewMatrix(Matrix4f modelViewMatrix) {
        MODEL_VIEW = new Matrix4f((Matrix4fc)modelViewMatrix);
    }

    public static void restoreModelViewMatrix() {
        LodestoneRenderHandler.setModelViewMatrix(MODEL_VIEW);
    }

    public static void clearModelViewMatrix() {
        LodestoneRenderHandler.setModelViewMatrix(new Matrix4f());
    }

    public static void setModelViewMatrix(Matrix4f modelViewMatrix) {
        RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
    }

    public static void copyDepthBuffer(RenderTarget tempRenderTarget) {
        LodestoneRenderHandler.setupDepthBuffer();
        LodestoneRenderHandler.enableStencil();
        if (tempRenderTarget == null) {
            return;
        }
        RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();
        tempRenderTarget.copyDepthFrom(mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.frameBufferId);
    }

    public static void setupDepthBuffer() {
        if (LODESTONE_DEPTH_CACHE == null) {
            LODESTONE_DEPTH_CACHE = new TextureTarget(Minecraft.getInstance().getMainRenderTarget().width, Minecraft.getInstance().getMainRenderTarget().height, true, Minecraft.ON_OSX);
        }
    }

    public static void enableStencil() {
        if (Minecraft.getInstance().getMainRenderTarget().isStencilEnabled()) {
            LODESTONE_DEPTH_CACHE.enableStencil();
        }
    }

    public static void cacheFogData(ViewportEvent.RenderFog event) {
        FOG_NEAR = event.getNearPlaneDistance();
        FOG_FAR = event.getFarPlaneDistance();
        FOG_SHAPE = event.getFogShape();
    }

    public static void cacheFogColors(ViewportEvent.ComputeFogColor event) {
        FOG_RED = event.getRed();
        FOG_GREEN = event.getGreen();
        FOG_BLUE = event.getBlue();
    }

    public static void applyCachedFogData() {
        float[] shaderFogColor = RenderSystem.getShaderFogColor();
        float fogRed = shaderFogColor[0];
        float fogGreen = shaderFogColor[1];
        float fogBlue = shaderFogColor[2];
        float shaderFogStart = RenderSystem.getShaderFogStart();
        float shaderFogEnd = RenderSystem.getShaderFogEnd();
        FogShape shaderFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void restoreFogData() {
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
    }

    public static void updateUniforms(RenderType renderType) {
        Optional<ShaderInstance> optional = RenderHelper.getShader(renderType);
        if (optional.isPresent()) {
            LodestoneRenderType lodestoneRenderType;
            ShaderUniformHandler handler;
            ShaderInstance shader = optional.get();
            if (renderType instanceof LodestoneRenderType && (handler = (lodestoneRenderType = (LodestoneRenderType)renderType).getUniformHandler()) != null) {
                handler.updateShaderData(shader);
            }
            shader.setSampler("SceneDepthBuffer", (Object)LODESTONE_DEPTH_CACHE.getDepthTextureId());
            shader.setSampler("SceneDiffuseBuffer", (Object)Minecraft.getInstance().getMainRenderTarget().getColorTextureId());
            shader.safeGetUniform("InvProjMat").set(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
        }
    }

    public static void resetUniforms(RenderType renderType) {
        ShaderInstance shaderInstance;
        Optional<ShaderInstance> optional = RenderHelper.getShader(renderType);
        if (optional.isPresent() && (shaderInstance = optional.get()) instanceof ExtendedShaderInstance) {
            ExtendedShaderInstance shader = (ExtendedShaderInstance)shaderInstance;
            shader.setUniformDefaults();
        }
    }

    static {
        DEFERRED_RENDER = new LodestoneRenderLayer();
        LATE_DEFERRED_RENDER = new LodestoneRenderLayer();
    }
}

