/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.CommonHooks;

public class LodestoneEnchantmentDataHelper {
    public static void runIterationOnItem(ItemStack stack, @Nullable Holder<Enchantment> filter, EnchantmentHelper.EnchantmentVisitor visitor) {
        LodestoneEnchantmentDataHelper.runIterationOnItem(stack, filter, visitor, () -> false);
    }

    public static void runIterationOnItem(ItemStack stack, @Nullable Holder<Enchantment> filter, EnchantmentHelper.EnchantmentVisitor visitor, BooleanSupplier breakCondition) {
        ItemEnchantments itemenchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup != null) {
            itemenchantments = stack.getAllEnchantments(lookup);
        }
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            if (filter != null && !filter.is(enchantment.getKey())) continue;
            visitor.accept(enchantment, entry.getIntValue());
            if (!breakCondition.getAsBoolean()) continue;
            return;
        }
    }

    protected static <T> List<T> getMatchingEffects(ItemStack item, DataComponentMap map, Class<T> type, Either<Predicate<TypedDataComponent<?>>, Predicate<T>> condition) {
        ArrayList<Object> effectObjects = new ArrayList<Object>();
        ArrayList<T> result = new ArrayList<T>();
        for (TypedDataComponent typedDataComponent : map) {
            Object value = typedDataComponent.value();
            if (!condition.left().map(e -> e.test(component)).orElse(true).booleanValue()) continue;
            if (value instanceof Collection) {
                Collection effectList = (Collection)value;
                effectObjects.addAll(effectList);
                continue;
            }
            effectObjects.add(value);
        }
        for (Object e2 : effectObjects) {
            List<T> effects = LodestoneEnchantmentDataHelper.getEffects(item, e2, type);
            for (T effect : effects) {
                if (!condition.right().map(e -> e.test(effect)).orElse(true).booleanValue()) continue;
                result.add(effect);
            }
        }
        return result;
    }

    public static <T> List<T> getEffects(ItemStack item, Object object, Class<T> type) {
        Optional requirements;
        ArrayList<T> effects = new ArrayList<T>();
        ArrayList<ConditionalEffect> conditionalEffects = new ArrayList<ConditionalEffect>();
        ArrayList<TargetedConditionalEffect> targetedConditionalEffects = new ArrayList<TargetedConditionalEffect>();
        if (object instanceof AllOf.EntityEffects) {
            AllOf.EntityEffects all = (AllOf.EntityEffects)object;
            for (EnchantmentEntityEffect effect : all.effects()) {
                effects.addAll(LodestoneEnchantmentDataHelper.getEffects(item, effect, type));
            }
        } else if (object instanceof AllOf.LocationBasedEffects) {
            AllOf.LocationBasedEffects locationBasedEffects = (AllOf.LocationBasedEffects)object;
            for (EnchantmentEntityEffect effect : locationBasedEffects.effects()) {
                effects.addAll(LodestoneEnchantmentDataHelper.getEffects(item, effect, type));
            }
        } else if (object instanceof AllOf.ValueEffects) {
            AllOf.ValueEffects all = (AllOf.ValueEffects)object;
            for (EnchantmentEntityEffect effect : all.effects()) {
                effects.addAll(LodestoneEnchantmentDataHelper.getEffects(item, effect, type));
            }
        }
        if (type.isInstance(object)) {
            effects.add(type.cast(object));
        } else if (object instanceof TargetedConditionalEffect) {
            TargetedConditionalEffect conditionalEffect = (TargetedConditionalEffect)object;
            targetedConditionalEffects.add(conditionalEffect);
        } else if (object instanceof ConditionalEffect) {
            ConditionalEffect conditionalEffect = (ConditionalEffect)object;
            conditionalEffects.add(conditionalEffect);
        }
        for (ConditionalEffect conditionalEffect : conditionalEffects) {
            requirements = conditionalEffect.requirements();
            if (!requirements.isEmpty() && !LodestoneEnchantmentDataHelper.matches(item, (LootItemCondition)requirements.get())) continue;
            effects.addAll(LodestoneEnchantmentDataHelper.getEffects(item, conditionalEffect.effect(), type));
        }
        for (TargetedConditionalEffect targetedConditionalEffect : targetedConditionalEffects) {
            requirements = targetedConditionalEffect.requirements();
            if (!requirements.isEmpty() && !LodestoneEnchantmentDataHelper.matches(item, (LootItemCondition)requirements.get())) continue;
            effects.addAll(LodestoneEnchantmentDataHelper.getEffects(item, targetedConditionalEffect.effect(), type));
        }
        return effects;
    }

    public static boolean matches(ItemStack item, LootItemCondition condition) {
        if (condition instanceof AllOfCondition) {
            AllOfCondition all = (AllOfCondition)condition;
            return all.terms.stream().allMatch(t -> LodestoneEnchantmentDataHelper.innerMatches(item, t));
        }
        if (condition instanceof AnyOfCondition) {
            AnyOfCondition any = (AnyOfCondition)condition;
            return any.terms.stream().anyMatch(t -> LodestoneEnchantmentDataHelper.innerMatches(item, t));
        }
        return LodestoneEnchantmentDataHelper.innerMatches(item, condition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean innerMatches(ItemStack item, LootItemCondition condition) {
        Optional predicate;
        InvertedLootItemCondition invertedLootItemCondition;
        if (condition instanceof InvertedLootItemCondition) {
            LootItemCondition lootItemCondition;
            invertedLootItemCondition = (InvertedLootItemCondition)condition;
            LootItemCondition term = lootItemCondition = invertedLootItemCondition.term();
            if (LodestoneEnchantmentDataHelper.innerMatches(item, term)) return false;
            return true;
        }
        if (!(condition instanceof MatchTool)) return true;
        invertedLootItemCondition = (MatchTool)condition;
        try {
            Optional optional;
            predicate = optional = invertedLootItemCondition.predicate();
            if (!predicate.isPresent()) return false;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!((ItemPredicate)predicate.get()).test(item)) return false;
        return true;
    }
}

