/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import team.lodestar.lodestone.systems.rendering.IVertexBuffer;

public interface IRenderableModel {
    public ResourceLocation getModelLocation();

    public void loadModel();

    public void render(PoseStack var1, VertexConsumer var2, RenderType var3);

    public VertexBuffer getModelBuffer();

    public void setModelBuffer(VertexBuffer var1);

    public MeshData createMesh(PoseStack var1, VertexFormat var2, VertexFormat.Mode var3);

    default public void render(PoseStack poseStack, RenderType renderType, MultiBufferSource.BufferSource bufferSource) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        this.render(poseStack, vertexConsumer, renderType);
    }

    default public void renderInstanced(PoseStack poseStack, Matrix4f frustrumMatrix, Matrix4f projectionMatrix, RenderType renderType, int instances) {
        this.createModelBuffer(poseStack, renderType);
        this.getModelBuffer().bind();
        renderType.setupRenderState();
        IVertexBuffer.cast(this.getModelBuffer()).drawWithShaderInstanced(frustrumMatrix, projectionMatrix, RenderSystem.getShader(), instances);
        renderType.clearRenderState();
        VertexBuffer.unbind();
    }

    @ApiStatus.Internal
    default public void createModelBuffer(PoseStack poseStack, RenderType renderType) {
        if (this.getModelBuffer() == null) {
            this.setModelBuffer(new VertexBuffer(VertexBuffer.Usage.DYNAMIC));
        }
        this.getModelBuffer().bind();
        this.getModelBuffer().upload(this.createMesh(poseStack, renderType));
        VertexBuffer.unbind();
    }

    @ApiStatus.Internal
    default public MeshData createMesh(PoseStack poseStack, RenderType renderType) {
        return this.createMesh(poseStack, renderType.format(), renderType.mode());
    }

    @ApiStatus.Internal
    default public void cleanup() {
        VertexBuffer buffer = this.getModelBuffer();
        if (buffer != null) {
            buffer.close();
            this.setModelBuffer(null);
        }
    }
}

