/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.geo;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import org.joml.Vector2f;
import org.joml.Vector3f;
import team.lodestar.lodestone.helpers.JsonHelper;
import team.lodestar.lodestone.systems.model.LodestoneParser;
import team.lodestar.lodestone.systems.model.geo.BedrockGeometryModel;
import team.lodestar.lodestone.systems.model.geo.data.GeoBone;
import team.lodestar.lodestone.systems.model.geo.data.GeoCube;
import team.lodestar.lodestone.systems.model.geo.data.GeoDescription;
import team.lodestar.lodestone.systems.model.geo.data.GeoQuad;
import team.lodestar.lodestone.systems.model.geo.data.GeoVertex;

public class BedrockGeometryParser
extends LodestoneParser<BedrockGeometryModel> {
    private final Map<String, GeoBone> bones = new HashMap<String, GeoBone>();
    private String version;
    private GeoDescription geoDescription;

    @Override
    public void parse(Resource resource, BedrockGeometryModel model) throws IOException {
        JsonObject json = GsonHelper.parse((Reader)resource.openAsReader());
        this.version = GsonHelper.getAsString((JsonObject)json, (String)"format_version");
        JsonArray geometries = json.getAsJsonArray("minecraft:geometry");
        for (int i = 0; i < geometries.size(); ++i) {
            this.parseGeometry(geometries.get(i).getAsJsonObject());
        }
        for (String boneName : this.bones.keySet()) {
            GeoBone bone = this.bones.get(boneName);
            if (bone.getParent() != null) {
                GeoBone parentBone = this.bones.get(bone.getParent());
                if (parentBone != null) {
                    parentBone.addChild(boneName, bone);
                    continue;
                }
                throw new IOException("Parent bone '" + bone.getParent() + "' not found for bone '" + boneName + "'");
            }
            model.root = bone;
        }
    }

    private void parseGeometry(JsonObject geometry) {
        this.geoDescription = this.parseDescription(geometry.getAsJsonObject("description"));
        JsonArray bones = geometry.getAsJsonArray("bones");
        for (int i = 0; i < bones.size(); ++i) {
            this.parseBone(bones.get(i).getAsJsonObject());
        }
    }

    private GeoDescription parseDescription(JsonObject description) {
        String identifier = GsonHelper.getAsString((JsonObject)description, (String)"identifier");
        int textureWidth = GsonHelper.getAsInt((JsonObject)description, (String)"texture_width");
        int textureHeight = GsonHelper.getAsInt((JsonObject)description, (String)"texture_height");
        float visibleBoundsWidth = GsonHelper.getAsFloat((JsonObject)description, (String)"visible_bounds_width");
        float visibleBoundsHeight = GsonHelper.getAsFloat((JsonObject)description, (String)"visible_bounds_height");
        Vector3f visibleBoundsOffset = JsonHelper.getAsVec3f(description, "visible_bounds_offset");
        return new GeoDescription(identifier, textureWidth, textureHeight, visibleBoundsWidth, visibleBoundsHeight, visibleBoundsOffset);
    }

    private GeoBone parseBone(JsonObject bone) {
        String name = GsonHelper.getAsString((JsonObject)bone, (String)"name");
        String parent = GsonHelper.getAsString((JsonObject)bone, (String)"parent", null);
        Vector3f pivot = JsonHelper.getAsVec3f(bone, "pivot");
        Vector3f rotation = JsonHelper.getAsVec3f(bone, "rotation");
        JsonArray cubes = bone.getAsJsonArray("cubes");
        ArrayList<GeoCube> geoCubes = new ArrayList<GeoCube>();
        if (cubes != null) {
            for (int i = 0; i < cubes.size(); ++i) {
                geoCubes.add(this.parseCube(cubes.get(i).getAsJsonObject()));
            }
        }
        GeoBone geoBone = new GeoBone(geoCubes, new HashMap<String, GeoBone>(), parent);
        geoBone.setPosition(pivot);
        if (rotation != null) {
            geoBone.setRotation(rotation.x, rotation.y, rotation.z);
        }
        this.bones.put(name, geoBone);
        return geoBone;
    }

    private GeoCube parseCube(JsonObject cube) {
        Vector3f origin = JsonHelper.getAsVec3f(cube, "origin");
        Vector3f size = JsonHelper.getAsVec3f(cube, "size");
        VertexSet vertexSet = VertexSet.fromCubeData(origin, size);
        JsonObject uv = cube.getAsJsonObject("uv");
        UVSet uvSet = new UVSet(this.parseUV(uv, "north"), this.parseUV(uv, "south"), this.parseUV(uv, "east"), this.parseUV(uv, "west"), this.parseUV(uv, "up"), this.parseUV(uv, "down"));
        ArrayList<GeoQuad> quads = new ArrayList<GeoQuad>();
        for (Direction direction : Direction.values()) {
            UVData uvData = uvSet.getFace(direction);
            if (uvData == null) continue;
            GeoQuad quad = GeoQuad.build(vertexSet.verticesForQuad(direction), uvData.uv, uvData.uvSize, uvData.uvRotation, new Vector2f((float)this.geoDescription.textureWidth(), (float)this.geoDescription.textureHeight()));
            quads.add(quad);
        }
        return new GeoCube(quads.toArray(new GeoQuad[0]), origin, size, new Vector3f());
    }

    @Nullable
    private UVData parseUV(JsonObject uvSet, String face) {
        if (!uvSet.has(face)) {
            return null;
        }
        JsonObject uv = uvSet.getAsJsonObject(face);
        Vector2f uvVec = JsonHelper.getAsVec2f(uv, "uv");
        Vector2f uvSize = JsonHelper.getAsVec2f(uv, "uv_size");
        int rot = GsonHelper.getAsInt((JsonObject)uv, (String)"uv_rotation", (int)0);
        return new UVData(uvVec, uvSize, rot);
    }

    private record VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
        public static VertexSet fromCubeData(Vector3f origin, Vector3f size) {
            GeoVertex blb = new GeoVertex(origin.x, origin.y, origin.z);
            GeoVertex brb = new GeoVertex(origin.x, origin.y, origin.z + size.z);
            GeoVertex tlb = new GeoVertex(origin.x, origin.y + size.y, origin.z);
            GeoVertex trb = new GeoVertex(origin.x, origin.y + size.y, origin.z + size.z);
            GeoVertex tlf = new GeoVertex(origin.x + size.x, origin.y + size.y, origin.z);
            GeoVertex trf = new GeoVertex(origin.x + size.x, origin.y + size.y, origin.z + size.z);
            GeoVertex blf = new GeoVertex(origin.x + size.x, origin.y, origin.z);
            GeoVertex brf = new GeoVertex(origin.x + size.x, origin.y, origin.z + size.z);
            return new VertexSet(blb, brb, tlb, trb, tlf, trf, blf, brf);
        }

        public GeoVertex[] verticesForQuad(Direction direction) {
            GeoVertex[] geoVertexArray;
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case WEST: {
                    GeoVertex[] geoVertexArray2 = new GeoVertex[4];
                    geoVertexArray2[0] = this.topLeftFront;
                    geoVertexArray2[1] = this.topRightFront;
                    geoVertexArray2[2] = this.bottomRightFront;
                    geoVertexArray = geoVertexArray2;
                    geoVertexArray2[3] = this.bottomLeftFront;
                    break;
                }
                case EAST: {
                    GeoVertex[] geoVertexArray3 = new GeoVertex[4];
                    geoVertexArray3[0] = this.topRightBack;
                    geoVertexArray3[1] = this.topLeftBack;
                    geoVertexArray3[2] = this.bottomLeftBack;
                    geoVertexArray = geoVertexArray3;
                    geoVertexArray3[3] = this.bottomRightBack;
                    break;
                }
                case NORTH: {
                    GeoVertex[] geoVertexArray4 = new GeoVertex[4];
                    geoVertexArray4[0] = this.topLeftBack;
                    geoVertexArray4[1] = this.topLeftFront;
                    geoVertexArray4[2] = this.bottomLeftFront;
                    geoVertexArray = geoVertexArray4;
                    geoVertexArray4[3] = this.bottomLeftBack;
                    break;
                }
                case SOUTH: {
                    GeoVertex[] geoVertexArray5 = new GeoVertex[4];
                    geoVertexArray5[0] = this.topRightFront;
                    geoVertexArray5[1] = this.topRightBack;
                    geoVertexArray5[2] = this.bottomRightBack;
                    geoVertexArray = geoVertexArray5;
                    geoVertexArray5[3] = this.bottomRightFront;
                    break;
                }
                case UP: {
                    GeoVertex[] geoVertexArray6 = new GeoVertex[4];
                    geoVertexArray6[0] = this.topRightBack;
                    geoVertexArray6[1] = this.topRightFront;
                    geoVertexArray6[2] = this.topLeftFront;
                    geoVertexArray = geoVertexArray6;
                    geoVertexArray6[3] = this.topLeftBack;
                    break;
                }
                case DOWN: {
                    GeoVertex[] geoVertexArray7 = new GeoVertex[4];
                    geoVertexArray7[0] = this.bottomLeftBack;
                    geoVertexArray7[1] = this.bottomLeftFront;
                    geoVertexArray7[2] = this.bottomRightFront;
                    geoVertexArray = geoVertexArray7;
                    geoVertexArray7[3] = this.bottomRightBack;
                }
            }
            return geoVertexArray;
        }
    }

    private record UVSet(@Nullable UVData north, @Nullable UVData south, @Nullable UVData east, @Nullable UVData west, @Nullable UVData up, @Nullable UVData down) {
        @Nullable
        public UVData getFace(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> this.north;
                case Direction.SOUTH -> this.south;
                case Direction.EAST -> this.east;
                case Direction.WEST -> this.west;
                case Direction.UP -> this.up;
                case Direction.DOWN -> this.down;
            };
        }
    }

    private record UVData(Vector2f uv, Vector2f uvSize, int uvRotation) {
    }
}

