/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.shaders.Uniform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

public class ExtendedShaderInstance
extends ShaderInstance {
    private static final Set<String> EXCLUDED_UNIFORMS = Set.of("ModelViewMat", "ProjMat", "TextureMat", "ScreenSize", "ColorModulator", "Light0_Direction", "Light1_Direction", "GlintAlpha", "FogStart", "FogEnd", "FogColor", "FogShape", "LineWidth", "GameTime", "ChunkOffset");
    protected final ShaderHolder shaderHolder;
    protected final Map<String, Consumer<Uniform>> defaultUniformData = new HashMap<String, Consumer<Uniform>>();

    public ExtendedShaderInstance(ResourceProvider pResourceProvider, ShaderHolder shaderHolder) throws IOException {
        super(pResourceProvider, shaderHolder.getShaderLocation(), shaderHolder.getShaderFormat());
        this.shaderHolder = shaderHolder;
        ResourceLocation jsonLocation = shaderHolder.getShaderLocation().withPath(p -> "shaders/core/" + p + ".json");
        try (BufferedReader reader = pResourceProvider.openAsReader(jsonLocation);){
            JsonObject shaderJson = GsonHelper.parse((Reader)reader);
            this.parseDefaultUniformValues(shaderJson);
        }
    }

    public void setUniformDefaults() {
        for (Map.Entry<String, Consumer<Uniform>> defaultDataEntry : this.getDefaultUniformData().entrySet()) {
            Uniform t = (Uniform)this.uniformMap.get(defaultDataEntry.getKey());
            defaultDataEntry.getValue().accept(t);
        }
    }

    public ShaderHolder getShaderHolder() {
        return this.shaderHolder;
    }

    public Map<String, Consumer<Uniform>> getDefaultUniformData() {
        return this.defaultUniformData;
    }

    public void parseDefaultUniformValues(JsonObject shaderJson) {
        JsonArray shaderUniforms = GsonHelper.getAsJsonArray((JsonObject)shaderJson, (String)"uniforms", null);
        if (shaderUniforms == null) {
            return;
        }
        for (JsonElement uniformJson : shaderUniforms) {
            Consumer<Uniform> consumer;
            JsonObject uniformObject = GsonHelper.convertToJsonObject((JsonElement)uniformJson, (String)"uniform");
            String uniformName = GsonHelper.getAsString((JsonObject)uniformObject, (String)"name");
            if (EXCLUDED_UNIFORMS.contains(uniformName)) continue;
            Uniform uniform = (Uniform)this.uniformMap.get(uniformName);
            if (uniform == null) {
                LodestoneLib.LOGGER.warn("Shader json {} has a uniform {} that is not present in the shader instance uniform map. This may cause issues.", (Object)this.shaderHolder.getShaderLocation(), (Object)uniformName);
                continue;
            }
            if (uniform.getType() <= 3) {
                buffer = uniform.getIntBuffer();
                ((IntBuffer)buffer).position(0);
                array = new int[uniform.getCount()];
                for (i = 0; i < uniform.getCount(); ++i) {
                    array[i] = ((IntBuffer)buffer).get(i);
                }
                consumer = arg_0 -> ExtendedShaderInstance.lambda$parseDefaultUniformValues$1((IntBuffer)buffer, (int[])array, arg_0);
            } else {
                buffer = uniform.getFloatBuffer();
                ((FloatBuffer)buffer).position(0);
                array = new float[uniform.getCount()];
                for (i = 0; i < uniform.getCount(); ++i) {
                    array[i] = (int)((FloatBuffer)buffer).get(i);
                }
                consumer = arg_0 -> ExtendedShaderInstance.lambda$parseDefaultUniformValues$2((FloatBuffer)buffer, (float[])array, arg_0);
            }
            this.getDefaultUniformData().put(uniformName, consumer);
        }
    }

    private static /* synthetic */ void lambda$parseDefaultUniformValues$2(FloatBuffer buffer, float[] array, Uniform u) {
        buffer.position(0);
        buffer.put(array);
    }

    private static /* synthetic */ void lambda$parseDefaultUniformValues$1(IntBuffer buffer, int[] array, Uniform u) {
        buffer.position(0);
        buffer.put(array);
    }
}

