/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.features;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;
import net.sirgrantd.magic_coins.config.ServerConfig;

@EventBusSubscriber
public class LostCoinsForDeath {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LostCoinsForDeath.handlePlayerDeath(player);
        }
    }

    private static void handlePlayerDeath(Player player) {
        int totalCoins = MagicCoinsApi.getTotalCoins((Entity)player);
        boolean isCoinsLostOnDeath = MagicCoinsApi.isCoinsLostOnDeath((Entity)player);
        if (totalCoins > 0) {
            double lossFactor = isCoinsLostOnDeath ? 1.0 : (double)ServerConfig.percentageCoinsSaveOnDeath / 100.0;
            int newTotalCoins = (int)Math.round((double)totalCoins * lossFactor);
            MagicCoinsApi.setTotalCoins((Entity)player, newTotalCoins);
        }
    }
}

