/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.features;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;

@EventBusSubscriber
public class ProsperityAmuletBonusEffect {
    @SubscribeEvent
    public static void onPlayerAttacked(LivingDamageEvent.Post event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ProsperityAmuletBonusEffect.handlePlayerAttacked(player);
        }
    }

    private static void handlePlayerAttacked(Player player) {
        boolean effectBonusActive = MagicCoinsApi.getPercentageCoinsSaveOnDeath() == 100 && MagicCoinsApi.isCoinsLostOnDeath((Entity)player);
        float health = player.getHealth();
        float maxHealth = player.getMaxHealth();
        if (effectBonusActive && (double)health <= (double)maxHealth * 0.5) {
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 0));
        }
    }
}

