/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.gui.handlers.collects;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.sirgrantd.magic_coins.MagicCoinsMod;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;
import net.sirgrantd.magic_coins.init.ItemsInit;
import net.sirgrantd.magic_coins.utils.Utils;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CollectAllCoinsInventory(int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CollectAllCoinsInventory> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"collect_coins_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectAllCoinsInventory> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CollectAllCoinsInventory(buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CollectAllCoinsInventory> type() {
        return TYPE;
    }

    public static void handleData(CollectAllCoinsInventory message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int x = message.x;
                int y = message.y;
                int z = message.z;
                CollectAllCoinsInventory.handleButtonAction(entity, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player player, int x, int y, int z) {
        if (player == null) {
            return;
        }
        Object object = player.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable itemHandlerModifiable = (IItemHandlerModifiable)object;
            int silverCoins = Utils.countItems((IItemHandler)itemHandlerModifiable, (Item)ItemsInit.SILVER_COIN.get());
            int goldCoins = Utils.countItems((IItemHandler)itemHandlerModifiable, (Item)ItemsInit.GOLD_COIN.get());
            int crystalCoins = Utils.countItems((IItemHandler)itemHandlerModifiable, (Item)ItemsInit.CRYSTAL_COIN.get());
            Utils.removeItemsFromInventory(player, (Item)ItemsInit.SILVER_COIN.get(), silverCoins);
            Utils.removeItemsFromInventory(player, (Item)ItemsInit.GOLD_COIN.get(), goldCoins);
            Utils.removeItemsFromInventory(player, (Item)ItemsInit.CRYSTAL_COIN.get(), crystalCoins);
            int totalCoins = silverCoins * MagicCoinsApi.getValueSilverCoins() + goldCoins * MagicCoinsApi.getValueGoldCoins() + crystalCoins * MagicCoinsApi.getValueCrystalCoins();
            MagicCoinsApi.addCoins((Entity)player, totalCoins);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MagicCoinsMod.addNetworkMessage(TYPE, STREAM_CODEC, CollectAllCoinsInventory::handleData);
    }
}

