/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.loots;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.sirgrantd.magic_coins.config.ServerConfig;

public class AddItemModifier
extends LootModifier {
    public static final MapCodec<AddItemModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list((Codec)ItemEntry.CODEC.codec()).fieldOf("items").forGetter(e -> e.items)).and((App)ResourceLocation.CODEC.listOf().fieldOf("loot_tables").forGetter(e -> e.lootTables)).apply((Applicative)inst, AddItemModifier::new));
    private final List<ItemEntry> items;
    private final List<ResourceLocation> lootTables;
    private final Random random = new Random();

    public AddItemModifier(LootItemCondition[] conditionsIn, List<ItemEntry> items, List<ResourceLocation> lootTables) {
        super(conditionsIn);
        this.items = items;
        this.lootTables = lootTables;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        if (!ServerConfig.coinsLootChests) {
            return generatedLoot;
        }
        ResourceLocation currentLootTable = lootContext.getQueriedLootTableId();
        if (!this.lootTables.contains(currentLootTable)) {
            return generatedLoot;
        }
        for (ItemEntry entry : this.items) {
            if (!(this.random.nextFloat() <= entry.chance)) continue;
            int count = entry.min + this.random.nextInt(entry.max - entry.min + 1);
            generatedLoot.add((Object)new ItemStack((ItemLike)entry.item, count));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static class ItemEntry {
        public static final MapCodec<ItemEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(itemEntry -> itemEntry.item), (App)Codec.FLOAT.fieldOf("chance").forGetter(itemEntry -> Float.valueOf(itemEntry.chance)), (App)Codec.INT.fieldOf("min").forGetter(itemEntry -> itemEntry.min), (App)Codec.INT.fieldOf("max").forGetter(itemEntry -> itemEntry.max)).apply((Applicative)inst, ItemEntry::new));
        public final Item item;
        public final float chance;
        public final int min;
        public final int max;

        public ItemEntry(Item item, float chance, int min, int max) {
            this.item = item;
            this.chance = chance;
            this.min = min;
            this.max = max;
        }
    }
}

