/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;
import team.lodestar.lodestone.systems.rendering.buffer.LodestoneRenderLayer;

public class SpiritBasedParticleBuilder
extends WorldParticleBuilder {
    @Nullable
    public SpiritArcanaType spiritType;

    public static SpiritBasedParticleBuilder createSpirit(Holder<? extends LodestoneWorldParticleType> particle) {
        return SpiritBasedParticleBuilder.createSpirit((LodestoneWorldParticleType)particle.value());
    }

    public static SpiritBasedParticleBuilder createSpirit(Supplier<? extends LodestoneWorldParticleType> particle) {
        return SpiritBasedParticleBuilder.createSpirit(particle.get());
    }

    public static SpiritBasedParticleBuilder createSpirit(LodestoneWorldParticleType particle) {
        return SpiritBasedParticleBuilder.createSpirit(new WorldParticleOptions((ParticleType)particle));
    }

    public static SpiritBasedParticleBuilder createSpirit(WorldParticleOptions options) {
        return new SpiritBasedParticleBuilder(options);
    }

    protected SpiritBasedParticleBuilder(WorldParticleOptions options) {
        super(options);
    }

    public SpiritBasedParticleBuilder setSpirit(SpiritLike spirit) {
        this.spiritType = spirit.getSpirit();
        if (this.isUmbral()) {
            super.setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT);
        }
        return this.setColorData((ColorParticleDataWrapper)this.spiritType.createColorData().build());
    }

    public boolean isUmbral() {
        return this.spiritType != null && this.spiritType.matches(MalumSpiritTypes.UMBRAL_SPIRIT);
    }

    public SpiritBasedParticleBuilder setRenderType(ParticleRenderType renderType) {
        if (this.isUmbral()) {
            return (SpiritBasedParticleBuilder)super.setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT);
        }
        return (SpiritBasedParticleBuilder)super.setRenderType(renderType);
    }

    public SpiritBasedParticleBuilder setLifetime(Supplier<Integer> lifetimeSupplier) {
        return (SpiritBasedParticleBuilder)super.setLifetime(lifetimeSupplier);
    }

    public SpiritBasedParticleBuilder setScaleData(GenericParticleDataWrapper scaleData) {
        if (this.isUmbral()) {
            scaleData.unwrap().multiplyCoefficient(1.5f);
        }
        return (SpiritBasedParticleBuilder)super.setScaleData(scaleData);
    }

    public SpiritBasedParticleBuilder setTransparencyData(GenericParticleDataWrapper transparencyData) {
        if (this.isUmbral()) {
            transparencyData.unwrap().multiplyValue(4.0f).multiplyCoefficient(1.5f);
        }
        return (SpiritBasedParticleBuilder)super.setTransparencyData(transparencyData);
    }

    public <T extends LodestoneParticleBehavior> SpiritBasedParticleBuilder setBehavior(Class<T> targetClass, Function<T, LodestoneParticleBehavior> tLodestoneParticleBehaviorFunction) {
        return (SpiritBasedParticleBuilder)super.setBehavior(targetClass, tLodestoneParticleBehaviorFunction);
    }

    public SpiritBasedParticleBuilder setBehavior(LodestoneParticleBehavior behavior) {
        return (SpiritBasedParticleBuilder)super.setBehavior(behavior);
    }

    public SpiritBasedParticleBuilder enableNoClip() {
        return (SpiritBasedParticleBuilder)super.enableNoClip();
    }

    public SpiritBasedParticleBuilder disableNoClip() {
        return (SpiritBasedParticleBuilder)super.disableNoClip();
    }

    public SpiritBasedParticleBuilder setNoClip(boolean noClip) {
        return (SpiritBasedParticleBuilder)super.setNoClip(noClip);
    }

    public SpiritBasedParticleBuilder setRenderTarget(LodestoneRenderLayer renderLayer) {
        return (SpiritBasedParticleBuilder)super.setRenderTarget(renderLayer);
    }

    public SpiritBasedParticleBuilder enableForcedSpawn() {
        return (SpiritBasedParticleBuilder)super.enableForcedSpawn();
    }

    public SpiritBasedParticleBuilder disableForcedSpawn() {
        return (SpiritBasedParticleBuilder)super.disableForcedSpawn();
    }

    public SpiritBasedParticleBuilder setForceSpawn(boolean forceSpawn) {
        return (SpiritBasedParticleBuilder)super.setForceSpawn(forceSpawn);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxSpeed);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxHSpeed, double maxVSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxHSpeed, maxVSpeed);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxXSpeed, maxYSpeed, maxZSpeed);
    }

    public SpiritBasedParticleBuilder addMotion(Vector3f motion) {
        return (SpiritBasedParticleBuilder)super.addMotion(motion);
    }

    public SpiritBasedParticleBuilder addMotion(Vec3 motion) {
        return (SpiritBasedParticleBuilder)super.addMotion(motion);
    }

    public SpiritBasedParticleBuilder addMotion(double vx, double vy, double vz) {
        return (SpiritBasedParticleBuilder)super.addMotion(vx, vy, vz);
    }

    public SpiritBasedParticleBuilder setMotion(Vector3f motion) {
        return (SpiritBasedParticleBuilder)super.setMotion(motion);
    }

    public SpiritBasedParticleBuilder setMotion(Vec3 motion) {
        return (SpiritBasedParticleBuilder)super.setMotion(motion);
    }

    public SpiritBasedParticleBuilder setMotion(double vx, double vy, double vz) {
        return (SpiritBasedParticleBuilder)super.setMotion(vx, vy, vz);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxDistance) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxDistance);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxHDist, double maxVDist) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxHDist, maxVDist);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxXDist, double maxYDist, double maxZDist) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxXDist, maxYDist, maxZDist);
    }

    public SpiritBasedParticleBuilder act(Consumer<WorldParticleBuilder> particleBuilderConsumer) {
        return (SpiritBasedParticleBuilder)super.act(particleBuilderConsumer);
    }

    public SpiritBasedParticleBuilder addTickActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addTickActor(particleActor);
    }

    public SpiritBasedParticleBuilder addSpawnActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addSpawnActor(particleActor);
    }

    public SpiritBasedParticleBuilder addRenderActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addRenderActor(particleActor);
    }

    public SpiritBasedParticleBuilder clearActors() {
        return (SpiritBasedParticleBuilder)super.clearActors();
    }

    public SpiritBasedParticleBuilder clearTickActors() {
        return (SpiritBasedParticleBuilder)super.clearTickActors();
    }

    public SpiritBasedParticleBuilder clearSpawnActors() {
        return (SpiritBasedParticleBuilder)super.clearSpawnActors();
    }

    public SpiritBasedParticleBuilder clearRenderActors() {
        return (SpiritBasedParticleBuilder)super.clearRenderActors();
    }

    public SpiritBasedParticleBuilder setNaturalLighting() {
        return (SpiritBasedParticleBuilder)super.setNaturalLighting();
    }

    public SpiritBasedParticleBuilder setFullBrightLighting() {
        return (SpiritBasedParticleBuilder)super.setFullBrightLighting();
    }

    public SpiritBasedParticleBuilder setLightLevel(int particleLight) {
        return (SpiritBasedParticleBuilder)super.setLightLevel(particleLight);
    }

    public SpiritBasedParticleBuilder spawn(Level level, double x, double y, double z) {
        return (SpiritBasedParticleBuilder)super.spawn(level, x, y, z);
    }

    public SpiritBasedParticleBuilder repeat(Level level, double x, double y, double z, int n) {
        return (SpiritBasedParticleBuilder)super.repeat(level, x, y, z, n);
    }

    public SpiritBasedParticleBuilder surroundBlock(Level level, BlockPos pos, Direction ... directions) {
        return (SpiritBasedParticleBuilder)super.surroundBlock(level, pos, directions);
    }

    public SpiritBasedParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n) {
        return (SpiritBasedParticleBuilder)super.repeatSurroundBlock(level, pos, n);
    }

    public SpiritBasedParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n, Direction ... directions) {
        return (SpiritBasedParticleBuilder)super.repeatSurroundBlock(level, pos, n, directions);
    }

    public SpiritBasedParticleBuilder surroundVoxelShape(Level level, BlockPos pos, VoxelShape voxelShape, int max) {
        return (SpiritBasedParticleBuilder)super.surroundVoxelShape(level, pos, voxelShape, max);
    }

    public SpiritBasedParticleBuilder surroundVoxelShape(Level level, BlockPos pos, BlockState state, int max) {
        return (SpiritBasedParticleBuilder)super.surroundVoxelShape(level, pos, state, max);
    }

    public SpiritBasedParticleBuilder spawnAtRandomFace(Level level, BlockPos pos) {
        return (SpiritBasedParticleBuilder)super.spawnAtRandomFace(level, pos);
    }

    public SpiritBasedParticleBuilder repeatRandomFace(Level level, BlockPos pos, int n) {
        return (SpiritBasedParticleBuilder)super.repeatRandomFace(level, pos, n);
    }

    public SpiritBasedParticleBuilder createBlockOutline(Level level, BlockPos pos, BlockState state) {
        return (SpiritBasedParticleBuilder)super.createBlockOutline(level, pos, state);
    }

    public SpiritBasedParticleBuilder spawnLine(Level level, Vec3 one, Vec3 two) {
        return (SpiritBasedParticleBuilder)super.spawnLine(level, one, two);
    }

    public SpiritBasedParticleBuilder modifyColorData(Consumer<ColorParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyColorData(dataConsumer);
    }

    public SpiritBasedParticleBuilder setColorData(ColorParticleDataWrapper colorData) {
        return (SpiritBasedParticleBuilder)super.setColorData(colorData);
    }

    public SpiritBasedParticleBuilder modifyScaleData(Consumer<GenericParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyScaleData(dataConsumer);
    }

    public SpiritBasedParticleBuilder modifyLengthData(Consumer<GenericParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyLengthData(dataConsumer);
    }

    public SpiritBasedParticleBuilder setLengthData(GenericParticleDataWrapper lengthData) {
        return (SpiritBasedParticleBuilder)super.setLengthData(lengthData);
    }

    public SpiritBasedParticleBuilder setLifeDelay(int lifeDelay) {
        return (SpiritBasedParticleBuilder)super.setLifeDelay(lifeDelay);
    }

    public SpiritBasedParticleBuilder setLifeDelay(Supplier<Integer> supplier) {
        return (SpiritBasedParticleBuilder)super.setLifeDelay(supplier);
    }

    public SpiritBasedParticleBuilder setLifetime(int lifetime) {
        return (SpiritBasedParticleBuilder)super.setLifetime(lifetime);
    }

    public SpiritBasedParticleBuilder setGravity(float gravity) {
        return (SpiritBasedParticleBuilder)super.setGravity(gravity);
    }

    public SpiritBasedParticleBuilder setGravity(Supplier<Float> supplier) {
        return (SpiritBasedParticleBuilder)super.setGravity(supplier);
    }

    public SpiritBasedParticleBuilder setFriction(float friction) {
        return (SpiritBasedParticleBuilder)super.setFriction(friction);
    }

    public SpiritBasedParticleBuilder setFriction(Supplier<Float> supplier) {
        return (SpiritBasedParticleBuilder)super.setFriction(supplier);
    }

    public SpiritBasedParticleBuilder multiplyLifeDelay(float multiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyLifeDelay(multiplier);
    }

    public SpiritBasedParticleBuilder modifyLifeDelay(Int2IntFunction modifier) {
        return (SpiritBasedParticleBuilder)super.modifyLifeDelay(modifier);
    }

    public SpiritBasedParticleBuilder multiplyLifetime(float multiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyLifetime(multiplier);
    }

    public SpiritBasedParticleBuilder modifyLifetime(Int2IntFunction modifier) {
        return (SpiritBasedParticleBuilder)super.modifyLifetime(modifier);
    }

    public SpiritBasedParticleBuilder multiplyGravity(float multiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyGravity(multiplier);
    }

    public SpiritBasedParticleBuilder modifyGravity(Float2FloatFunction modifier) {
        return (SpiritBasedParticleBuilder)super.modifyGravity(modifier);
    }

    public SpiritBasedParticleBuilder multiplyFriction(float multiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyFriction(multiplier);
    }

    public SpiritBasedParticleBuilder modifyFriction(Float2FloatFunction modifier) {
        return (SpiritBasedParticleBuilder)super.modifyFriction(modifier);
    }

    public SpiritBasedParticleBuilder setSpinData(SpinParticleDataWrapper spinData) {
        return (SpiritBasedParticleBuilder)super.setSpinData(spinData);
    }

    public SpiritBasedParticleBuilder modifySpinData(Consumer<SpinParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifySpinData(dataConsumer);
    }

    public SpiritBasedParticleBuilder modifyTransparencyData(Consumer<GenericParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyTransparencyData(dataConsumer);
    }

    public SpiritBasedParticleBuilder setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        return (SpiritBasedParticleBuilder)super.setSpritePicker(spritePicker);
    }
}

