/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.totemancy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.item.HeldItemTracker;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.MalumTags;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class TotemBaseRenderer
implements BlockEntityRenderer<TotemBaseBlockEntity> {
    public static final HeldItemTracker STAFF_TRACKER = new HeldItemTracker(p -> p.is(MalumTags.ItemTags.IS_TOTEMIC_TOOL));

    public TotemBaseRenderer(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(TotemBaseBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }

    public void render(TotemBaseBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (STAFF_TRACKER.isVisible()) {
            SpiritRiteType riteType = blockEntityIn.getRite();
            if (riteType == null) {
                return;
            }
            float scalar = Easing.SINE_IN_OUT.ease(STAFF_TRACKER.getDelta(partialTicks), 0.0f, 1.0f);
            SpiritHolder<SpiritArcanaType> spirit = riteType.getIdentifyingSpirit();
            SpiritRiteEffect riteEffect = riteType.getEffect();
            if (riteEffect instanceof SpiritRiteEntityEffect) {
                SpiritRiteEntityEffect entityEffect = (SpiritRiteEntityEffect)riteEffect;
                int size = entityEffect.getEffectRange();
                if (size > 1) {
                    size = size * 2 + 1;
                }
                float distortion = 6.0f + (float)size;
                LodestoneRenderTypeBuilder border = LodestoneRenderTypes.ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE.apply(MalumRenderTypeTokens.AREA_COVERAGE_BORDER).withUniformHandler(new ShaderUniformHandler().modifyUniform("Speed", new float[]{1500.0f}).modifyUniform("Distortion", new float[]{distortion}));
                LodestoneRenderTypeBuilder squiggles = LodestoneRenderTypes.ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE.apply(MalumRenderTypeTokens.AREA_COVERAGE_SQUIGGLES).withUniformHandler(new ShaderUniformHandler().modifyUniform("Speed", new float[]{2500.0f}).modifyUniform("Distortion", new float[]{distortion * 2.0f}));
                LodestoneRenderTypeBuilder checkerboard = LodestoneRenderTypes.ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE.apply(MalumRenderTypeTokens.AREA_COVERAGE_CHECKERBOARD).withUniformHandler(new ShaderUniformHandler().modifyUniform("Speed", new float[]{500.0f}).modifyUniform("Distortion", new float[]{distortion / 2.0f}));
                poseStack.pushPose();
                poseStack.translate(0.5f, 0.5f, 0.5f);
                for (int i = 0; i < 2; ++i) {
                    float cubeSize = i == 0 ? (float)size : (float)(-size);
                    Color primaryColor = i == 0 ? spirit.getPrimaryColor() : spirit.getSecondaryColor();
                    Color secondaryColor = i == 0 ? spirit.getSecondaryColor() : spirit.getPrimaryColor();
                    CubeVertexData borderArea = CubeVertexData.makeCubePositions((float)cubeSize).applyWobble(0.0f, 0.5f, 0.01f).scale(1.1f);
                    CubeVertexData squiggleArea = CubeVertexData.makeCubePositions((float)cubeSize).applyWobble(0.2f, 0.7f, 0.02f).scale(1.09f);
                    CubeVertexData checkerboardArea = CubeVertexData.makeCubePositions((float)cubeSize).applyWobble(0.5f, 0.0f, 0.03f).scale(1.08f);
                    SpiritBasedWorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spirit);
                    builder.setRenderType(border).setColor(primaryColor, 0.95f * scalar).renderCube(poseStack, borderArea);
                    builder.setRenderType(squiggles).setColor(secondaryColor, 0.8f * scalar).renderCube(poseStack, squiggleArea);
                    builder.setRenderType(checkerboard).setColor(primaryColor, 0.6f * scalar).renderCube(poseStack, checkerboardArea);
                }
                poseStack.popPose();
            }
        }
    }
}

