/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.totemancy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class TotemPoleRenderer
implements BlockEntityRenderer<TotemPoleBlockEntity> {
    public TotemPoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TotemPoleBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SpiritArcanaType spiritType = blockEntityIn.getSpirit();
        if (spiritType == null) {
            return;
        }
        Direction direction = (Direction)blockEntityIn.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ClientLevel level = Minecraft.getInstance().level;
        LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(RenderTypeToken.createToken((ResourceLocation)spiritType.getGlowTexture()));
        float delta = blockEntityIn.getGlowDelta();
        float alpha = delta * 0.7f;
        float ease = Easing.SINE_OUT.ease(delta, 0.0f, 1.0f, 1.0f);
        float offsetDistance = 0.2f - ease * 0.2f;
        float wobbleStrength = 0.1f - ease * 0.075f;
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-0.5125f, 0.0f, 0.5125f), new Vector3f(0.5125f, 0.0f, 0.5125f), new Vector3f(0.5125f, 1.0f, 0.5125f), new Vector3f(-0.5125f, 1.0f, 0.5125f)};
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(direction.toYRot()));
        float gameTime = (float)level.getGameTime() + partialTicks;
        int time = 160;
        for (int i = 0; i < 4; ++i) {
            Color color = i <= 2 ? spiritType.getPrimaryColor() : spiritType.getSecondaryColor();
            double offset = 0.0;
            if (offsetDistance > 0.0f) {
                double angle = (double)((float)i / 4.0f) * (Math.PI * 2);
                offset = (double)offsetDistance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                if (i % 2 == 0) {
                    offset *= -1.0;
                }
            }
            poseStack.pushPose();
            poseStack.translate(offset, 0.0, 0.0);
            CubeVertexData.applyVertexWobble((Vector3f[])vertices, (float)0.0f, (float)wobbleStrength);
            SpiritBasedWorldVFXBuilder.create(spiritType).setColor(color, alpha).setRenderType(renderType).renderQuad(poseStack, vertices, 1.0f);
            poseStack.popPose();
            alpha *= 1.0f - (delta + 0.2f) * 0.5f;
        }
        poseStack.popPose();
    }
}

