/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.activator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractEffectActivatorEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    public AbstractEffectActivatorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.ADDITIVE_ROUNDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(renderType);
        Color primaryColor = this.getSpiritType(entity).getPrimaryColor();
        Color secondaryColor = this.getSpiritType(entity).getSecondaryColor();
        RenderUtils.renderEntityTrail(poseStack, builder, this.getTrail(entity), entity, primaryColor, secondaryColor, this.getScale(entity, false), this.getAlpha(entity, false), partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, this.getLongTrail(entity), entity, primaryColor, secondaryColor, this.getScale(entity, true), this.getAlpha(entity, true), partialTicks);
        super.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public abstract SpiritArcanaType getSpiritType(T var1);

    public abstract float getScale(T var1, boolean var2);

    public abstract float getAlpha(T var1, boolean var2);

    public abstract TrailPointBuilder getTrail(T var1);

    public abstract TrailPointBuilder getLongTrail(T var1);

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

