/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.nitrate;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;

public class AbstractNitrateEntityRenderer<T extends AbstractNitrateEntity>
extends EntityRenderer<T> {
    public final Function<Float, Color> primaryColor;
    public final Function<Float, Color> secondaryColor;

    public AbstractNitrateEntityRenderer(EntityRendererProvider.Context context, Function<Float, Color> primaryColor, Function<Float, Color> secondaryColor) {
        super(context);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public AbstractNitrateEntityRenderer(EntityRendererProvider.Context context, Color primaryColor, Color secondaryColor) {
        this(context, (Float f) -> primaryColor, (Float f) -> secondaryColor);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float effectScalar = ((AbstractNitrateEntity)((Object)entity)).getVisualEffectScalar();
        LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.ADDITIVE_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(renderType);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractNitrateEntity)((Object)entity)).trailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractNitrateEntity)((Object)entity)).spinningTrailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, partialTicks);
        if (((AbstractNitrateEntity)((Object)entity)).age > 1 && !((AbstractNitrateEntity)((Object)entity)).fadingAway) {
            poseStack.pushPose();
            float glimmerScale = 3.0f * Math.min(1.0f, (float)(((AbstractNitrateEntity)((Object)entity)).age - 2) / 5.0f);
            poseStack.scale(glimmerScale, glimmerScale, glimmerScale);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, this.primaryColor.apply(Float.valueOf(0.0f)), this.secondaryColor.apply(Float.valueOf(0.125f)), partialTicks);
            poseStack.popPose();
        }
        super.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

