/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects.progression;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.WidgetDesign;
import com.sammy.malum.client.screen.codex.WidgetDesignType;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.AbstractSelectableEntryObject;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ProgressionEntryObject
extends AbstractSelectableEntryObject<AbstractProgressionCodexScreen> {
    public WidgetDesign design = WidgetDesignType.DEFAULT.createDesign(WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER);
    public boolean isOrigin;
    protected int oldOutlineVisibility;
    protected int outlineVisibility;

    public ProgressionEntryObject(BookEntry entry, int posX, int posY) {
        super(entry, posX, posY, 32, 32);
    }

    @Override
    public boolean isInView(AbstractProgressionCodexScreen screen) {
        return screen.isInView(this.getOffsetXPosition(), this.getOffsetYPosition()) || screen.isInView(this.getOffsetXPosition() + this.width, this.getOffsetYPosition()) || screen.isInView(this.getOffsetXPosition(), this.getOffsetYPosition() + this.height) || screen.isInView(this.getOffsetXPosition() + this.width, this.getOffsetYPosition() + this.height);
    }

    @Override
    public void tick(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        if (this.design.getDesignType().equals(WidgetDesignType.EMPTY)) {
            return;
        }
        this.oldOutlineVisibility = this.outlineVisibility;
        if (this.isHoveredOver) {
            if (this.outlineVisibility == 6) {
                screen.playSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_ENTRY_HOVER, 0.2f, 1.0f);
            }
            if (this.outlineVisibility < 20) {
                this.outlineVisibility = Math.min(this.outlineVisibility + 2, 20);
            }
        } else {
            if (this.outlineVisibility == 15) {
                screen.playSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_ENTRY_UNHOVER, 0.1f, 0.75f);
            }
            if (this.outlineVisibility > 0) {
                --this.outlineVisibility;
            }
        }
    }

    @Override
    public void applyTransforms(AbstractProgressionCodexScreen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        float effectStrength = Mth.lerp((float)partialTicks, (float)this.oldOutlineVisibility, (float)this.outlineVisibility) / 20.0f;
        if (effectStrength > 0.0f) {
            float offset = Easing.CIRC_OUT.ease(effectStrength, 0.0f, 2.0f);
            poseStack.translate(0.0f, -offset, 0.0f);
        }
    }

    @Override
    public void render(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        int posX = this.getOffsetXPosition() - 16;
        int posY = this.getOffsetYPosition() - 16;
        int centerX = this.getCenterX();
        int centerY = this.getCenterY();
        CodexRenderHelper.renderTexture(WIDGET_FADE_TEXTURE, poseStack, centerX - 29, centerY - 29, 0.0f, 0.0f, 58, 58);
        if (this.design != null) {
            Minecraft minecraft = screen.getMinecraft();
            float delta = minecraft.getTimer().getGameTimeDeltaPartialTick(true);
            float effectStrength = Mth.lerp((float)delta, (float)this.oldOutlineVisibility, (float)this.outlineVisibility) / 20.0f;
            if (effectStrength > 0.0f) {
                float distortionIntensity = 5.0f + 35.0f * effectStrength;
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float darknessAlpha = Math.min(effectStrength * 2.5f, 1.0f);
                this.renderOutline(poseStack, distortionIntensity, darknessAlpha, WidgetDesignType::getOutlineTexture, (Int2ObjectFunction<Color>)((Int2ObjectFunction)i -> Color.BLACK));
                if (effectStrength >= 0.5f) {
                    float glowAlpha = (effectStrength - 0.5f) * 2.0f;
                    RenderSystem.blendFunc((int)770, (int)1);
                    this.renderOutline(poseStack, distortionIntensity, glowAlpha, WidgetDesignType::getGlowTexture, (Int2ObjectFunction<Color>)((Int2ObjectFunction)this::getSpiritColor));
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
            }
            this.design.getFrameTexture().ifPresent(texture -> CodexRenderHelper.renderTexture(texture, poseStack, posX, posY, 0.0f, 0.0f, 64, 64));
            this.design.getFillingTexture().ifPresent(texture -> CodexRenderHelper.renderTexture(texture, poseStack, posX, posY, 0.0f, 0.0f, 64, 64));
        }
        if (this.iconStack != null) {
            guiGraphics.renderItem(this.iconStack, centerX - 8, centerY - 8);
        }
    }

    @Override
    public List<Component> gatherTooltip(AbstractProgressionCodexScreen screen) {
        List<Component> tooltip = super.gatherTooltip(screen);
        ImmutableList<EntryReference> references = this.entry.references;
        for (int i = references.size() - 1; i >= 0; --i) {
            EntryReference reference = (EntryReference)references.get(i);
            if (!reference.entry.shouldShow()) continue;
            MutableComponent slash = Component.literal((String)"\u2507 ");
            MutableComponent text = Component.translatable((String)reference.entry.translationKey());
            MutableComponent component = slash.append((Component)text).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add(1, (Component)component);
        }
        return tooltip;
    }

    public void renderOutline(PoseStack poseStack, float distortionIntensity, float intensity, Function<WidgetDesignType, ResourceLocation> texture, Int2ObjectFunction<Color> colorSupplier) {
        int posX = this.getOffsetXPosition() - 16;
        int posY = this.getOffsetYPosition() - 16;
        Minecraft minecraft = Minecraft.getInstance();
        float delta = minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        ExtendedShaderInstance light = LodestoneShaders.RADIAL_DISTORTED_SCREEN_LIGHT.getShaderInstance();
        light.safeGetUniform("YFrequency").set(24.0f);
        light.safeGetUniform("XFrequency").set(32.0f);
        light.safeGetUniform("Speed").set(2000.0f);
        light.safeGetUniform("Intensity").set(distortionIntensity);
        light.safeGetUniform("LumiTransparency").set(1.0f);
        light.safeGetUniform("Width").set(80.0f);
        light.safeGetUniform("Height").set(80.0f);
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setTexture(texture.apply(this.design.getDesignType())).setPositionWithWidth((float)posX, (float)posY, 64.0f, 64.0f).setShader((ShaderInstance)light);
        float offset = this.hashCode() % 3600;
        float time = ((float)minecraft.level.getGameTime() + delta) * 0.4f + offset;
        for (int i = 0; i < 8; ++i) {
            int angle = (int)((time * 2.0f + (float)(i * 90)) % 720.0f);
            float glowAlpha = 1.0f - Mth.abs((float)(1.0f - (float)angle / 180.0f));
            if (angle >= 360) continue;
            light.safeGetUniform("Angle").set(angle);
            builder.setColor((Color)colorSupplier.get(i));
            for (int j = 0; j < 2; ++j) {
                float range = 120.0f * (float)(j + 1) * intensity;
                light.safeGetUniform("LightAngleRange").set(range);
                builder.setAlpha(glowAlpha * intensity).blit(poseStack);
            }
        }
        light.setUniformDefaults();
    }

    public Color getSpiritColor(int index) {
        SpiritArcanaType[] spirits = new SpiritArcanaType[]{(SpiritArcanaType)MalumSpiritTypes.SACRED_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.AERIAL_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.WICKED_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.AQUEOUS_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.EARTHEN_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.ELDRITCH_SPIRIT.get(), (SpiritArcanaType)MalumSpiritTypes.INFERNAL_SPIRIT.get()};
        return spirits[index].getPrimaryColor();
    }

    public int getCenterX() {
        return this.getOffsetXPosition() + this.width / 2;
    }

    public int getCenterY() {
        return this.getOffsetYPosition() + this.height / 2;
    }

    public ProgressionEntryObject setIcon(Supplier<? extends Item> item) {
        return (ProgressionEntryObject)super.setIcon(item);
    }

    public ProgressionEntryObject setIcon(Item item) {
        return (ProgressionEntryObject)super.setIcon(item);
    }

    public ProgressionEntryObject setIcon(Holder<GeasEffectType> geas) {
        return (ProgressionEntryObject)super.setIcon(geas);
    }

    public ProgressionEntryObject setIcon(ItemStack itemStack) {
        return (ProgressionEntryObject)super.setIcon(itemStack);
    }

    public ProgressionEntryObject setCondition(Predicate<AbstractProgressionCodexScreen> isValid) {
        return (ProgressionEntryObject)super.setCondition(isValid);
    }

    public ProgressionEntryObject setDesign(WidgetDesignType design, WidgetDesignType.FrameType frame, WidgetDesignType.FillingType filling) {
        return this.setDesign(design.createDesign(frame, filling));
    }

    public ProgressionEntryObject setDesign(WidgetDesign design) {
        this.design = design;
        return this;
    }

    public ProgressionEntryObject setOrigin() {
        this.isOrigin = true;
        return this;
    }
}

