/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe.vanilla;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.registry.common.item.MalumItems;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.neoforged.fml.ModList;

public class CraftingPage
extends BookPage {
    private final ItemStack outputStack;
    private final List<ItemStack> inputStacks;

    public CraftingPage(ItemStack outputStack, List<ItemStack> inputStacks) {
        super(MalumMod.malumPath("textures/gui/book/pages/crafting_page.png"));
        this.outputStack = outputStack;
        this.inputStacks = inputStacks;
    }

    public CraftingPage(ItemStack outputStack, ItemStack ... inputStacks) {
        this(outputStack, List.of(inputStacks));
    }

    public CraftingPage(Item outputItem, Item ... inputItems) {
        this(outputItem.getDefaultInstance(), inputItems);
    }

    public CraftingPage(ItemStack outputStack, Item ... inputItems) {
        this(outputStack, Arrays.stream(inputItems).map(Item::getDefaultInstance).toList());
    }

    @Override
    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack stack;
                int index = i * 3 + j;
                if (this.inputStacks.size() <= index || (stack = this.inputStacks.get(index)).isEmpty()) continue;
                int itemPosX = left + 42 + j * 21;
                int itemPosY = top + 35 + i * 21;
                CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, stack, itemPosX, itemPosY, mouseX, mouseY);
            }
        }
        CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, this.outputStack, left + 63, top + 132, mouseX, mouseY);
    }

    public static CraftingPage shapeless(Item output, Item ... inputs) {
        return new CraftingPage(output.getDefaultInstance(), inputs);
    }

    public static CraftingPage fullPage(Item output, Item input) {
        return CraftingPage.fullPage(output.getDefaultInstance(), input.getDefaultInstance());
    }

    public static CraftingPage fullPage(ItemStack output, ItemStack input) {
        return new CraftingPage(output, input, input, input, input, input, input, input, input, input);
    }

    public static CraftingPage bannerPage(Item input, SoulwovenBannerPatternDataComponent pattern) {
        return new CraftingPage(pattern.getDefaultStack(), (Item)MalumItems.SOULWOVEN_BANNER.get(), input);
    }

    public static CraftingPage scythePage(Item scythe, Item metal, Item reagent) {
        return CraftingPage.scythePage(scythe.getDefaultInstance(), metal.getDefaultInstance(), reagent.getDefaultInstance());
    }

    public static CraftingPage scythePage(ItemStack scythe, ItemStack metal, ItemStack reagent) {
        ItemStack stick = Items.STICK.getDefaultInstance();
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(scythe, metal, metal, reagent, empty, stick, metal, stick, empty, empty);
    }

    public static CraftingPage broochPage(Item brooch, Item ingot, Item block) {
        return CraftingPage.broochPage(brooch.getDefaultInstance(), Items.LEATHER.getDefaultInstance(), ingot.getDefaultInstance(), block.getDefaultInstance());
    }

    public static CraftingPage broochPage(ItemStack brooch, ItemStack material, ItemStack ingot, ItemStack block) {
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(brooch, empty, material, empty, material, ingot, material, empty, block, empty);
    }

    public static CraftingPage ringPage(Item ring, Item reagent) {
        return CraftingPage.ringPage(ring.getDefaultInstance(), Items.LEATHER.getDefaultInstance(), reagent.getDefaultInstance());
    }

    public static CraftingPage ringPage(ItemStack ring, ItemStack material, ItemStack reagent) {
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(ring, reagent, material, empty, material, empty, material, empty, material, empty);
    }

    public static CraftingPage itemPedestalPage(Item pedestal, Item fullBlock, Item slab) {
        return CraftingPage.itemPedestalPage(pedestal.getDefaultInstance(), fullBlock.getDefaultInstance(), slab.getDefaultInstance());
    }

    public static CraftingPage itemPedestalPage(ItemStack pedestal, ItemStack fullBlock, ItemStack slab) {
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(pedestal, slab, slab, slab, empty, fullBlock, empty, slab, slab, slab);
    }

    public static CraftingPage itemStandPage(Item stand, Item fullBlock, Item slab) {
        return CraftingPage.itemStandPage(stand.getDefaultInstance(), fullBlock.getDefaultInstance(), slab.getDefaultInstance());
    }

    public static CraftingPage itemStandPage(ItemStack stand, ItemStack fullBlock, ItemStack slab) {
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(stand.copyWithCount(2), empty, empty, empty, slab, slab, slab, fullBlock, fullBlock, fullBlock);
    }

    public static CraftingPage toolPage(Item tool, Item metal) {
        return CraftingPage.toolPage(tool.getDefaultInstance(), metal.getDefaultInstance());
    }

    public static CraftingPage toolPage(ItemStack tool, ItemStack metal) {
        ItemStack stick = Items.STICK.getDefaultInstance();
        ItemStack empty = Items.AIR.getDefaultInstance();
        Item item = tool.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SwordItem.class, AxeItem.class, HoeItem.class, ShovelItem.class, PickaxeItem.class}, (Object)item2, n)) {
            case 0 -> {
                SwordItem swordItem = (SwordItem)item2;
                yield new CraftingPage(tool, empty, metal, empty, empty, metal, empty, empty, stick, empty);
            }
            case 1 -> {
                AxeItem axeItem = (AxeItem)item2;
                yield new CraftingPage(tool, metal, metal, empty, metal, stick, empty, empty, stick, empty);
            }
            case 2 -> {
                HoeItem hoeItem = (HoeItem)item2;
                yield new CraftingPage(tool, metal, metal, empty, empty, stick, empty, empty, stick, empty);
            }
            case 3 -> {
                ShovelItem shovelItem = (ShovelItem)item2;
                yield new CraftingPage(tool, empty, metal, empty, empty, stick, empty, empty, stick, empty);
            }
            case 4 -> {
                PickaxeItem pickaxeItem = (PickaxeItem)item2;
                yield new CraftingPage(tool, metal, metal, metal, empty, stick, empty, empty, stick, empty);
            }
            default -> null;
        };
    }

    public static CraftingPage knifePage(Item tool, Item metal) {
        return CraftingPage.knifePage(tool.getDefaultInstance(), metal.getDefaultInstance());
    }

    public static CraftingPage knifePage(ItemStack tool, ItemStack metal) {
        ItemStack stick = Items.STICK.getDefaultInstance();
        ItemStack empty = Items.AIR.getDefaultInstance();
        return new CraftingPage(tool, new ItemStack[]{empty, empty, empty, empty, metal, empty, stick, empty}){

            @Override
            public boolean isValid() {
                return ModList.get().isLoaded("farmersdelight");
            }
        };
    }
}

