/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.gust_igniter;

import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GustIgniterBlock
extends AbstractGustGizmoBlock<GustIgniterBlockEntity> {
    public GustIgniterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos;
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Level level = context.getLevel();
        if (level.getBlockEntity((pos = context.getClickedPos()).relative(direction = context.getClickedFace().getOpposite())) instanceof WindTunnelBlockEntity) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)direction);
        }
        boolean powered = level.hasNeighborSignal(pos);
        level.scheduleTick(pos, (Block)this, 2);
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide) {
            boolean flag = (Boolean)state.getValue((Property)POWERED);
            if (flag != level.hasNeighborSignal(pos)) {
                if (flag) {
                    level.scheduleTick(pos, (Block)this, 4);
                } else {
                    GustIgniterBlock.activate(level, pos, true);
                    level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                }
            }
            if (flag) {
                GustIgniterBlock.activate(level, pos, true);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!level.hasNeighborSignal(pos)) {
                state = (BlockState)state.cycle((Property)POWERED);
                level.setBlock(pos, state, 2);
            }
            GustIgniterBlock.activate((Level)level, pos, (Boolean)state.getValue((Property)POWERED));
        }
    }

    public static void activate(Level level, BlockPos pos, boolean powered) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GustIgniterBlockEntity)) {
            return;
        }
        GustIgniterBlockEntity igniter = (GustIgniterBlockEntity)blockEntity;
        igniter.activate(powered);
    }
}

