/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.soul_brazier;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.soul_brazier.BrazierSoundInstance;
import com.sammy.malum.common.block.curiosities.soul_brazier.SoulBrazierBlock;
import com.sammy.malum.common.recipe.SoulBindingRecipe;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.SoulBindingBrazierParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.brazier.SoulBrazierAcceptSacrificeParticleEffect;
import com.sammy.malum.visual_effects.networked.brazier.SoulBrazierStateEffectData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.helpers.block.BlockPosHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SoulBrazierBlockEntity
extends LodestoneBlockEntity
implements IItemHandlerSupplier {
    public static final StringRepresentable.EnumCodec<BrazierState> CODEC = StringRepresentable.fromEnum(BrazierState::values);
    public static final Vec3 BRAZIER_ITEM_OFFSET = new Vec3(0.5, 1.125, 0.5);
    public static final Vec3 BRAZIER_GEAS_ICON_OFFSET = new Vec3(0.5, 4.0, 0.5);
    private static final int WARMUP_DURATION = 40;
    private static final int SOULBINDING_DURATION = 600;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public Supplier<IItemHandler> exposedInventory = () -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory});
    public SoulBindingRecipe recipe;
    public BrazierState state = BrazierState.IDLE;
    public float warmupTimer;
    public int progress;
    public boolean isReady;
    public List<UUID> sacrificedTargets = new ArrayList<UUID>();
    public float extrasAmount;
    public float extrasSpin;
    public float spiritAmount;
    public float spiritSpin;

    public SoulBrazierBlockEntity(BlockEntityType<? extends SoulBrazierBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SoulBrazierBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SoulBrazierBlockEntity>)((BlockEntityType)MalumBlockEntities.SOUL_BRAZIER.get()), pos, state);
        this.inventory = MalumBlockEntityInventory.stacksNotSpirits(this, 9).onContentsChanged(this::updateRecipe);
        this.spiritInventory = MalumSpiritBlockEntityInventory.spiritStacks(this).onContentsChanged(this::updateRecipe);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.exposedInventory.get();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.inventory.save(pRegistries, compound);
        this.spiritInventory.save(pRegistries, compound, "spiritInventory");
        compound.putString("state", this.state.name);
        compound.putFloat("warmupTimer", this.warmupTimer);
        compound.putInt("progress", this.progress);
        compound.putBoolean("isReady", this.isReady);
        ListTag list = new ListTag();
        for (UUID uuid : this.sacrificedTargets) {
            list.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        compound.put("sacrificedTargets", (Tag)list);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.inventory.load(pRegistries, compound);
        this.spiritInventory.load(pRegistries, compound, "spiritInventory");
        this.state = compound.contains("state") ? (BrazierState)CODEC.byName(compound.getString("state")) : BrazierState.IDLE;
        this.warmupTimer = compound.getFloat("warmupTimer");
        this.progress = compound.getInt("progress");
        this.isReady = compound.getBoolean("isReady");
        this.sacrificedTargets.clear();
        for (Tag tag : compound.getList("sacrificedTargets", 11)) {
            this.sacrificedTargets.add(NbtUtils.loadUUID((Tag)tag));
        }
        if (this.level != null) {
            this.updateRecipe();
            if (this.level.isClientSide && this.isActive()) {
                BrazierSoundInstance.playSound(this);
            }
        }
        super.loadAdditional(compound, pRegistries);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.level, this.worldPosition);
        this.spiritInventory.dumpItems(this.level, this.worldPosition);
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.attemptSoulbinding(serverLevel, pPlayer, pPlayer.getItemInHand(pHand))) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.isActive()) {
            if (this.addSacrifice(serverLevel, (LivingEntity)pPlayer)) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack spiritResult = this.spiritInventory.interact(serverLevel, pPlayer, pHand);
        if (!spiritResult.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack result = this.inventory.interact(serverLevel, pPlayer, pHand);
        if (!result.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUse(pPlayer, pHand);
    }

    public void clientTick(Level level) {
        if (this.isActive()) {
            ++this.progress;
        }
        this.spiritAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.getFilledSlotCount()));
        this.extrasAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.extrasAmount, (float)(this.inventory.getFilledSlotCount() - 1)));
        float extraSpeed = Math.min((float)this.progress / 100.0f, 5.0f) * this.getSpinUp(Easing.BOUNCE_IN_OUT);
        float speed = 1.0f + this.getSpinUp(Easing.SINE_IN_OUT) * 0.4f + extraSpeed;
        this.spiritSpin += speed;
        this.extrasSpin -= speed;
        SoulBindingBrazierParticleEffects.passiveBrazierParticles(this);
    }

    public void commonTick(Level level) {
        this.warmupTimer = this.isReady ? (this.warmupTimer += 1.0f) : Mth.clamp((float)(this.warmupTimer - 1.0f), (float)0.0f, (float)40.0f);
    }

    public void serverTick(ServerLevel level) {
        if (!this.isReady && this.recipe != null || this.isReady && this.recipe == null) {
            this.isReady = !this.isReady;
            BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
            this.setDirty();
        }
        if (this.isActive()) {
            ++this.progress;
            if (this.recipe == null) {
                this.updateRecipe();
                if (this.recipe == null) {
                    this.state = BrazierState.IDLE;
                    this.setDirty();
                    return;
                }
            }
            if (this.progress % 20 == 0) {
                AABB radius = new AABB(this.worldPosition).inflate(4.0);
                List entities = level.getEntitiesOfClass(LivingEntity.class, radius);
                for (LivingEntity entity : entities) {
                    if (!entity.hasEffect(MobEffects.WEAKNESS)) continue;
                    this.addSacrifice(level, entity);
                }
            }
            if (this.progress > 600) {
                ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
                for (UUID uuid : this.sacrificedTargets) {
                    LivingEntity entity;
                    Entity entity2 = level.getEntity(uuid);
                    if (!(entity2 instanceof LivingEntity)) continue;
                    entity = (LivingEntity)entity2;
                    targets.add(entity);
                }
                this.completeSoulBinding(level, targets);
            }
        } else {
            this.sacrificedTargets.clear();
            this.progress = Math.max(this.progress - 10, 0);
        }
    }

    public boolean attemptSoulbinding(ServerLevel level, @Nullable Player player, ItemStack stack) {
        if (this.recipe == null) {
            return false;
        }
        if (this.isActive()) {
            return false;
        }
        Item item = stack.getItem();
        if (item.equals(MalumItems.ETHER.get())) {
            this.beginSoulbinding(level, BrazierState.BINDING);
        } else if (item.equals(MalumItems.PARACAUSAL_FLAME.get())) {
            this.beginSoulbinding(level, BrazierState.UNBINDING);
        }
        if (this.isIdle()) {
            return false;
        }
        if (player != null && !player.isCreative()) {
            stack.shrink(1);
        }
        return true;
    }

    public void beginSoulbinding(ServerLevel level, BrazierState newState) {
        this.state = newState;
        this.sacrificedTargets.clear();
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.BRAZIER_START.get(), SoundSource.BLOCKS, 2.0f, 1.3f + level.random.nextFloat() * 0.3f);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.BRAZIER_START.get(), SoundSource.BLOCKS, 2.0f, 0.9f + level.random.nextFloat() * 0.3f);
        MalumParticleEffectTypes.SOULBINDING_BRAZIER_BEGINS.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpirits(this.recipe.spirits)).customData(new SoulBrazierStateEffectData(this.state)).spawn(level);
        level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SoulBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        this.setDirty();
    }

    public boolean addSacrifice(ServerLevel level, LivingEntity entity) {
        UUID uuid = entity.getUUID();
        if (!this.sacrificedTargets.contains(uuid)) {
            this.sacrificedTargets.add(uuid);
            entity.hurt(DamageTypeHelper.create((Level)level, MalumDamageTypes.KARMIC), entity.getMaxHealth() / 4.0f);
            level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.BRAZIER_SACRIFICE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
            MalumParticleEffectTypes.SOULBINDING_BRAZIER_ACCEPTS_SACRIFICE.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpirits(this.recipe.spirits)).customData(new SoulBrazierAcceptSacrificeParticleEffect.SoulBrazierEntityEffectData(entity.getId())).spawn(level);
            this.setDirty();
            return true;
        }
        return false;
    }

    public void completeSoulBinding(ServerLevel level, List<LivingEntity> targets) {
        this.sacrificedTargets.clear();
        if (this.recipe == null) {
            this.updateRecipe();
            if (this.recipe == null) {
                return;
            }
        }
        block0: for (SpiritIngredient spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.test(spiritStack)) continue;
                spiritStack.shrink(spirit.count());
                continue block0;
            }
        }
        ArrayList<SizedIngredient> extraIngredients = new ArrayList<SizedIngredient>(this.recipe.extraInputs);
        this.inventory.getStackInSlot(0).shrink(this.recipe.input.count());
        block2: for (SizedIngredient ingredient : extraIngredients) {
            for (int i = 0; i < this.inventory.slotCount; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (!ingredient.test(stack)) continue;
                stack.shrink(ingredient.count());
                continue block2;
            }
        }
        for (LivingEntity target : targets) {
            boolean success = false;
            if (this.state.equals((Object)BrazierState.BINDING)) {
                success = GeasEffectHandler.addGeasEffect(target, this.recipe.result);
            } else if (this.state.equals((Object)BrazierState.UNBINDING)) {
                success = GeasEffectHandler.removeGeasEffect(target, this.recipe.result);
            }
            if (success) continue;
            target.hurt(DamageTypeHelper.create((Level)level, MalumDamageTypes.KARMIC), target.getMaxHealth() / 2.0f);
        }
        MalumParticleEffectTypes.SOULBINDING_BRAZIER_ENDS.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpirits(this.recipe.spirits)).customData(new SoulBrazierStateEffectData(this.state)).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.BRAZIER_FINISH.get(), SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
        level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SoulBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        this.state = BrazierState.IDLE;
        this.updateRecipe();
        this.setDirty();
    }

    public void updateRecipe() {
        this.inventory.updateInventoryCaches();
        this.spiritInventory.updateInventoryCaches();
        this.recipe = (SoulBindingRecipe)LodestoneRecipeType.getRecipe((Level)this.level, (RecipeType)((RecipeType)MalumRecipeTypes.SOUL_BINDING.get()), (RecipeInput)new SpiritBasedRecipeInput(this.inventory.nonEmptyItemStacks, (List<ItemStack>)this.spiritInventory.nonEmptyItemStacks));
    }

    public boolean isActive() {
        return !this.state.equals((Object)BrazierState.IDLE) && this.recipe != null;
    }

    public boolean isIdle() {
        return this.state.equals((Object)BrazierState.IDLE);
    }

    public Vec3 getItemPos() {
        return BlockPosHelper.fromBlockPos((BlockPos)this.getBlockPos()).add(BRAZIER_ITEM_OFFSET);
    }

    public Vec3 getSpiritOffset(int slot, float partialTicks) {
        float projectedSpin = this.spiritSpin + 1.0f + this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f;
        float spinLerp = this.spiritSpin + partialTicks * (projectedSpin - this.spiritSpin);
        float distance = 1.25f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + Mth.sin((float)(spinLerp / 20.0f % 6.28f)) * 0.025f;
        float height = 1.0f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.9f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (float)spinLerp, (float)360.0f);
    }

    public Vec3 getExtrasOffset(int slot, float partialTicks) {
        float projectedSpin = this.extrasSpin - 1.0f - this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f;
        float spinLerp = this.extrasSpin + partialTicks * (projectedSpin - this.extrasSpin);
        float distance = 1.1f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + Mth.sin((float)(spinLerp / 20.0f % 6.28f)) * 0.025f;
        float height = 0.8f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.7f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.extrasAmount, (float)spinLerp, (float)360.0f);
    }

    public float getSpinUp(Easing easing) {
        if (this.warmupTimer >= 40.0f) {
            return 1.0f;
        }
        return easing.ease(this.warmupTimer / 40.0f, 0.0f, 1.0f, 1.0f);
    }

    public static enum BrazierState implements StringRepresentable
    {
        IDLE("idle"),
        BINDING("binding"),
        UNBINDING("unbinding");

        public final String name;

        private BrazierState(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

