/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_catalyzer;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.spirit_catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;

public class CatalyzerArtificeModifierSourceInstance
extends ArtificeModifierSourceInstance {
    public static final ResourceLocation ID = MalumMod.malumPath("spirit_catalyzer");
    public final SpiritCatalyzerCoreBlockEntity catalyzer;

    protected CatalyzerArtificeModifierSourceInstance(SpiritCatalyzerCoreBlockEntity catalyzer) {
        super(ID, catalyzer.getBlockPos(), 8);
        this.catalyzer = catalyzer;
    }

    @Override
    public void modifyFocusing(Consumer<ArtificeModifier> modifierConsumer) {
        modifierConsumer.accept(new ArtificeModifier(ArtificeAttributeType.FOCUSING_SPEED, 0.5f));
        modifierConsumer.accept(new ArtificeModifier(ArtificeAttributeType.INSTABILITY, 0.05f));
    }

    @Override
    public void applyAugments(Consumer<ItemStack> augmentConsumer) {
        ItemStack augment = this.catalyzer.augmentInventory.getStackInSlot(0);
        if (!augment.isEmpty()) {
            augmentConsumer.accept(augment);
        }
    }

    @Override
    public void tickFocusing(ArtificeAttributeData attributes) {
        float ratio = attributes.fuelUsageRate.getValue(attributes) * attributes.focusingSpeed.getValue(attributes);
        if (ratio > 0.0f) {
            this.catalyzer.burnTicks -= ratio;
        }
    }

    @Override
    public boolean canModifyFocusing(ArtificeAttributeData attributes) {
        if (attributes.fuelUsageRate.getValue(attributes) <= 0.0f) {
            return true;
        }
        if (this.catalyzer.burnTicks > 0.0f) {
            return true;
        }
        ItemStack stack = this.catalyzer.inventory.getStackInSlot(0);
        int burnTime = stack.getBurnTime(RecipeType.SMELTING);
        if (!stack.isEmpty() && burnTime > 0) {
            this.catalyzer.burnTicks = (float)burnTime / 2.0f;
            Level level = this.catalyzer.getLevel();
            if (stack.hasCraftingRemainingItem()) {
                ItemStack remainder = stack.getCraftingRemainingItem();
                BlockPos catalyzerPos = this.catalyzer.getBlockPos();
                Vec3 spawnPos = SpiritCatalyzerCoreBlockEntity.CATALYZER_ITEM_OFFSET.add((double)catalyzerPos.getX(), (double)catalyzerPos.getY(), (double)catalyzerPos.getZ());
                ItemEntity entity = new ItemEntity(level, spawnPos.x, spawnPos.y, spawnPos.z, remainder);
                level.addFreshEntity((Entity)entity);
            }
            stack.shrink(1);
            BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)this.catalyzer.getBlockPos());
        }
        return this.catalyzer.burnTicks > 0.0f;
    }

    @Override
    public boolean consumesFuel() {
        return true;
    }

    @Override
    public void addParticles(IArtificeAcceptor target, SpiritArcanaType spiritType) {
        if (this.catalyzer.burnTicks > 0.0f) {
            SpiritCrucibleParticleEffects.activeSpiritCatalyzerParticles(this.catalyzer, target, spiritType);
        }
    }
}

