/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.effect.rite.aura.soulwood;

import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class OakenMightEffect
extends MobEffect {
    public OakenMightEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorHelper.getColor((Color)MalumSpiritTypes.EARTHEN_COLORS().primaryColor()));
    }

    public static void increaseDamage(LivingDamageEvent.Pre event) {
        DamageSource source = event.getSource();
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity entity2 = (LivingEntity)entity;
            if (!source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                return;
            }
            MobEffectInstance instance = entity2.getEffect(MalumMobEffects.OAKEN_MIGHT);
            if (instance == null) {
                return;
            }
            if (entity2 instanceof Player && (player = (Player)entity2).getAttackStrengthScale(0.0f) < 0.9f) {
                return;
            }
            int amplifier = instance.getAmplifier() + 1;
            ItemStack weapon = entity2.getWeaponItem();
            if (weapon.isEmpty() || weapon.is(MalumTags.ItemTags.COUNTS_AS_EMPTY_HAND)) {
                amplifier *= 2;
                SoundHelper.playSound((Entity)entity2, (SoundEvent)((SoundEvent)MalumSoundEvents.OAKEN_MIGHT_HIT.get()), (float)1.0f, (float)(0.8f + entity2.getRandom().nextFloat() * 0.4f));
            }
            event.setNewDamage(event.getNewDamage() + (float)amplifier);
        }
    }
}

