/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.curiosities.weapons.SunderingAnchorItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SunderingAnchorProjectileEntity
extends ThrowableItemProjectile {
    public TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)60);
    public TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)8);
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
    protected float damage;
    protected float magicDamage;
    public int age;
    public int reboundDelay;
    public int bounceCount;
    public boolean isReturning;
    public int returnTimer;
    public int slot;
    private final List<Entity> ignoredTargets = new ArrayList<Entity>();
    private final Object2IntOpenHashMap<Entity> hitCount = new Object2IntOpenHashMap();
    private LivingEntity forcedTarget;

    public SunderingAnchorProjectileEntity(Level level) {
        super((EntityType)MalumEntities.SUNDERING_ANCHOR.get(), level);
        this.noPhysics = false;
    }

    public SunderingAnchorProjectileEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = true;
    }

    public void setData(LivingEntity owner, float damage, float magicDamage, int slot) {
        this.setOwner((Entity)owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.slot = slot;
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.SUNDERING_ANCHOR.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.damage != 0.0f) {
            compound.putFloat("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.reboundDelay != 0) {
            compound.putInt("reboundDelay", this.reboundDelay);
        }
        if (this.bounceCount != 0) {
            compound.putInt("bounceCount", this.bounceCount);
        }
        if (this.isReturning) {
            compound.putBoolean("isReturning", true);
        }
        if (this.returnTimer != 0) {
            compound.putInt("returnTimer", this.returnTimer);
        }
        if (this.slot != 0) {
            compound.putInt("slot", this.slot);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
        this.magicDamage = compound.getFloat("magicDamage");
        this.age = compound.getInt("age");
        this.reboundDelay = compound.getInt("reboundDelay");
        this.bounceCount = compound.getInt("bounceCount");
        this.isReturning = compound.getBoolean("isReturning");
        this.returnTimer = compound.getInt("returnTimer");
        this.slot = compound.getInt("slot");
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.revalidateTarget();
        this.bounce();
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.isReturning) {
            return;
        }
        if (this.forcedTarget != null && this.forcedTarget.isAlive() && this.position().distanceTo(this.forcedTarget.position()) < 2.0) {
            return;
        }
        super.onHitBlock(result);
        if (result.getDirection().getAxis().isVertical()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
        } else if (result.getDirection().getAxis().equals((Object)Direction.Axis.X)) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
        } else if (result.getDirection().getAxis().equals((Object)Direction.Axis.Z)) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
        }
        this.jumbleMovement(0.2f);
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity target = result.getEntity();
            this.hitTarget(level2, target);
        }
    }

    protected boolean canHitEntity(Entity pTarget) {
        return false;
    }

    protected boolean canHitEntityStupidCopy(Entity pTarget) {
        if (pTarget.equals((Object)this.getOwner())) {
            return false;
        }
        if (pTarget instanceof SunderingAnchorProjectileEntity) {
            return false;
        }
        if (this.ignoredTargets.contains(pTarget)) {
            return false;
        }
        if (this.hitCount.getInt((Object)pTarget) >= 5) {
            return false;
        }
        return super.canHitEntity(pTarget);
    }

    public void tick() {
        Vec3 deltaMovement = this.getDeltaMovement();
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(deltaMovement.length()));
        ++this.age;
        ++this.returnTimer;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            AABB aabb = this.getBoundingBox().inflate(2.0);
            for (Entity target : level2.getEntities((Entity)this, aabb, this::canHitEntityStupidCopy)) {
                LivingEntity owner;
                Entity entity = this.getOwner();
                if (entity instanceof LivingEntity && target.isAlliedTo((Entity)(owner = (LivingEntity)entity))) continue;
                this.onHit((HitResult)new EntityHitResult(target));
            }
            if (this.age % 20 == 0) {
                this.revalidateTarget();
                this.selectNearestTarget(level2);
            }
            if (this.isReturning) {
                Entity target;
                target = this.getOwner();
                if (target instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)target;
                    Vec3 ownerPos = owner.position().add(0.0, (double)(owner.getBbHeight() * 0.6f), 0.0);
                    float velocityLimit = 3.0f;
                    Vec3 motion = this.getDeltaMovement();
                    double velocity = Mth.clamp((double)(motion.length() * 1.25), (double)0.5, (double)velocityLimit);
                    Vec3 returnMotion = ownerPos.subtract(this.position()).normalize().scale(velocity);
                    this.setDeltaMovement(motion.lerp(returnMotion, (double)0.3f));
                    if (this.isAlive() && this.distanceTo((Entity)owner) < 2.5f) {
                        SoundHelper.playSound((Entity)owner, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_CATCH.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)this.level().getRandom(), (float)1.5f, (float)2.0f));
                        if (owner instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)owner;
                            float cooldownScalar = this.hitCount.isEmpty() ? 0.25f : 1.0f;
                            TemporarilyDisabledItem.enable(player, this.slot);
                            SunderingAnchorItem.applyCooldown(this.getItem(), (Player)player, cooldownScalar);
                        }
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                if (this.bounceCount >= 20 || this.returnTimer > 80) {
                    this.returnToOwner();
                }
                if (this.reboundDelay > 0) {
                    --this.reboundDelay;
                    if (this.reboundDelay == 0) {
                        this.selectNearestTarget(level2);
                    }
                }
                this.homeIn(level2);
            }
        } else {
            this.spawnParticles();
            Vec3 projectileDirection = this.getDeltaMovement().normalize();
            float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(projectileDirection);
            Vec3 newMotion = left.scale((double)(0.1f - this.random.nextFloat() * 0.2f)).add(up.scale((double)(0.1f - this.random.nextFloat() * 0.2f)));
            this.setDeltaMovement(this.getDeltaMovement().lerp(newMotion, (double)0.2f));
            float offsetScale = Mth.clampedLerp((float)0.1f, (float)0.3f, (float)this.getVisualEffectScalar());
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.add(left.scale(xOffset)).add(up.scale(zOffset)));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
    }

    @NotNull
    public SoundSource getSoundSource() {
        return this.getOwner() != null ? this.getOwner().getSoundSource() : SoundSource.PLAYERS;
    }

    public void shootFromRotation(@NotNull Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, innacuracy);
    }

    public void jumbleMovement(float weight) {
        float randomRotationX = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationY = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationZ = (float)(Math.random() * Math.PI * 2.0);
        Vec3 motion = this.getDeltaMovement();
        Vec3 newMotion = motion.xRot(randomRotationX).yRot(randomRotationY);
        double cosZ = Math.cos(randomRotationZ);
        double sinZ = Math.sin(randomRotationZ);
        double x = newMotion.x * cosZ - newMotion.y * sinZ;
        double y = newMotion.x * sinZ + newMotion.y * cosZ;
        double z = newMotion.z;
        Vec3 lerp = motion.lerp(new Vec3(x, y, z), (double)weight);
        this.setDeltaMovement(lerp.normalize().scale(motion.length()));
    }

    public void selectNearestTarget(ServerLevel level) {
        Entity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        List<LivingEntity> entities = this.getTargets(level, target -> this.hitCount.getInt(target) < 5);
        if (entities.isEmpty()) {
            this.forcedTarget = null;
            this.returnToOwner();
            return;
        }
        this.forcedTarget = entities.size() == 1 ? entities.getFirst() : (LivingEntity)entities.stream().filter(e -> !this.ignoredTargets.contains(e)).min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).orElse(null);
        if (this.forcedTarget != null) {
            double speed = this.getDeltaMovement().length();
            for (int i = 0; i < 3; ++i) {
                Vec3 distance = this.forcedTarget.position().subtract(this.position());
                Vec3 newMotion = this.getDeltaMovement().lerp(distance.normalize(), (double)0.3f);
                this.setDeltaMovement(newMotion.normalize());
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(speed));
        }
    }

    public void hitTarget(ServerLevel level, Entity target) {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.ignoredTargets.add(target);
            this.hitCount.addTo((Object)target, 1);
            target.invulnerableTime = 0;
            DamageSource source = DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.VOODOO, (Entity)this, (Entity)owner);
            float magicDamage = Math.max(this.magicDamage - 1.0f, 0.25f);
            boolean success = target.hurt(source, 1.0f);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                int slashCount = 5;
                ResourceKey<DamageType> physicalDamageType = MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO;
                ResourceKey<DamageType> magicDamageType = MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO;
                int delay = 8;
                float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.5f, (float)2.0f);
                SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_SWING.get()), (float)2.0f, (float)pitch);
                SunderingAnchorItem.applyHatred(livingEntity);
                for (int j = 0; j < slashCount; ++j) {
                    int comboDelay = delay + j;
                    WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)new DelayedDamageWorldEvent(target).setAttacker((Entity)owner).setDamageData(physicalDamageType, this.damage / (float)slashCount, magicDamageType, magicDamage / (float)slashCount, comboDelay).setImpactParticleEffect(MalumParticleEffectTypes.SUNDERING_ANCHOR_SWEEP, new MalumNetworkedParticleEffectColorData(SunderingAnchorItem.getSunderingAnchorSpirit())).setSound((Holder<SoundEvent>)MalumSoundEvents.SUNDERING_ANCHOR_PROJECTILE_SWING, 1.25f, 1.5f, 0.7f));
                }
                this.selectNearestTarget(level);
                this.jumbleMovement(0.8f);
            }
        }
    }

    public void homeIn(ServerLevel level) {
        Entity nearest;
        Vec3 motion = this.getDeltaMovement();
        Entity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        boolean demandAccuracy = true;
        if (this.forcedTarget != null && this.forcedTarget.isAlive() && !this.ignoredTargets.contains(this.forcedTarget)) {
            nearest = this.forcedTarget;
            demandAccuracy = false;
        } else if (owner.position().distanceTo(this.position()) > 30.0) {
            nearest = owner;
            demandAccuracy = false;
        } else {
            List<LivingEntity> targets = this.getTargets(level, target -> !this.ignoredTargets.contains(target) && this.hitCount.getInt(target) < 5);
            nearest = targets.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).orElse(null);
        }
        if (nearest != null) {
            Vec3 nearestPosition = nearest.position().add(0.0, (double)(nearest.getBbHeight() / 2.0f), 0.0);
            Vec3 distance = nearestPosition.subtract(this.position());
            double speed = motion.length();
            Vec3 nextPosition = this.position().add(this.getDeltaMovement());
            if (demandAccuracy && nearest.distanceToSqr(nextPosition) > nearest.distanceToSqr(this.position())) {
                return;
            }
            Vec3 newMotion = distance.normalize();
            double dot = motion.normalize().dot(distance.normalize());
            if (demandAccuracy && dot < (double)0.1f) {
                return;
            }
            if (newMotion.length() == 0.0) {
                newMotion = newMotion.add(0.01, 0.0, 0.0);
            }
            float angleScalar = Math.max((Mth.abs((float)((float)(0.5 - dot))) - 0.2f) * 2.5f, 0.4f);
            float factor = 0.125f * angleScalar;
            if (!demandAccuracy) {
                factor = Mth.clamp((float)((float)(1.0 - distance.length() / 80.0) * 2.0f), (float)0.1f, (float)0.5f);
            }
            double x = Mth.clampedLerp((double)motion.x, (double)newMotion.x, (double)factor);
            double y = Mth.clampedLerp((double)motion.y, (double)newMotion.y, (double)factor);
            double z = Mth.clampedLerp((double)motion.z, (double)newMotion.z, (double)factor);
            this.setDeltaMovement(new Vec3(x, y, z).normalize().scale(speed));
        }
    }

    public List<LivingEntity> getTargets(ServerLevel level, Predicate<LivingEntity> extraFilter) {
        Entity owner = this.getOwner();
        if (owner == null) {
            return Collections.emptyList();
        }
        AABB aabb = this.getBoundingBox().inflate(30.0);
        List targets = level.getEntitiesOfClass(LivingEntity.class, aabb, target -> this.isValidTarget(level, (LivingEntity)target, owner) && extraFilter.test((LivingEntity)target));
        if (!targets.stream().allMatch(t -> t instanceof Player)) {
            targets.removeIf(t -> {
                Player player;
                return t instanceof Player && !(player = (Player)t).hasEffect(MalumMobEffects.HATRED);
            });
        }
        return targets;
    }

    public boolean isValidTarget(ServerLevel level, LivingEntity target, Entity owner) {
        TamableAnimal tamableAnimal;
        if (target == owner) {
            return false;
        }
        if (target.isDeadOrDying()) {
            return false;
        }
        if (target.isAlliedTo(owner)) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).isTame()) {
            return false;
        }
        return this.hasLineOfSight(level, (Entity)target);
    }

    public void returnToOwner() {
        if (this.age > 30) {
            this.isReturning = true;
        }
    }

    public void bounce() {
        ++this.bounceCount;
        this.reboundDelay = 3;
        this.returnTimer -= 10;
    }

    public void revalidateTarget() {
        if (!this.ignoredTargets.isEmpty()) {
            float chance = 0.8f - (float)this.ignoredTargets.size() * 0.1f;
            if (this.random.nextFloat() < chance) {
                this.ignoredTargets.remove(this.ignoredTargets.get(this.random.nextInt(this.ignoredTargets.size())));
            }
        }
    }

    public boolean hasLineOfSight(ServerLevel level, Entity target) {
        Vec3 wrathPosition = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 targetPosition = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        BlockHitResult clipResult = level.clip(new ClipContext(wrathPosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return clipResult.getType().equals((Object)HitResult.Type.MISS);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 8) {
            effectScalar = (float)this.age / 8.0f;
        }
        return effectScalar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        SpiritLike spirit = SunderingAnchorItem.getSunderingAnchorSpirit();
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, this.position(), spirit);
        lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        float count = 1.0f + (float)this.getDeltaMovement().length() * 3.0f;
        int i = 0;
        while ((float)i < count) {
            spirit = SunderingAnchorItem.getSunderingAnchorSpirit();
            Vec3 position = this.getPosition((float)i / count);
            WorldParticleBuilder.create(MalumParticles.ROUNDABOUT_SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.7f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)spirit.createColorData().build()).setLifetime(Math.min(5 + this.age * 2, 20)).addTickActor(behavior).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.3f * scalar), (float)(0.5f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)ColorHelper.darker((Color)spirit.getPrimaryColor(), (int)2)).build()).spawn(level, position.x, position.y, position.z);
            ++i;
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

