/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumEntityDataSerializers;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class EntityRiteEffectActivatorEntity
extends FloatingEntity {
    protected static final EntityDataAccessor<SpiritArcanaType> DATA_SPIRIT_GLOW = SynchedEntityData.defineId(EntityRiteEffectActivatorEntity.class, (EntityDataSerializer)((EntityDataSerializer)MalumEntityDataSerializers.SPIRIT_ARCANA.get()));
    protected SpiritRiteEntityEffect<?> effect;

    public EntityRiteEffectActivatorEntity(Level level) {
        super((EntityType)MalumEntities.RITE_ENTITY_EFFECT_ACTIVATOR.get(), level);
        this.maxAge = 4000;
    }

    public EntityRiteEffectActivatorEntity(Level level, SpiritRiteEntityEffect<?> effect, UUID targetUUID, Vec3 position, Vec3 velocity) {
        this(level);
        this.effect = effect;
        this.setDestination(new FloatingItemDestinationData(targetUUID));
        this.setPos(position);
        this.setDeltaMovement(velocity);
        this.maxAge = 800;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SPIRIT_GLOW, (Object)((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        SpiritArcanaType spirit = this.getSpiritType();
        if (spirit != null) {
            spirit.save(pCompound);
        }
        if (this.effect != null) {
            this.effect.save(pCompound);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSpirit(SpiritArcanaType.load(pCompound).orElse((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
        this.effect = SpiritRiteEntityEffect.CODEC.load(pCompound, SpiritRiteEntityEffect.class).orElse(null);
    }

    @Override
    public void collect(ServerLevel level) {
        if (this.effect != null) {
            this.getDestination().getEntityCollector(level).ifPresent(target -> {
                this.effect.tryApplyEffect(level, (LivingEntity)target);
                SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)this.effect.getImpactSound().value()), (float)this.effect.getImpactSoundVolume((LivingEntity)target), (float)Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.1f));
            });
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.getOffsetPosition(), this.getSpiritType());
            lightSpecs.getBuilder().modifyScaleData(d -> d.multiplyValue(1.5f)).multiplyLifetime(2.0f);
            lightSpecs.getBloomBuilder().multiplyLifetime(2.0f);
            lightSpecs.spawnParticles();
        }
    }

    @Override
    public int getWindUpDuration() {
        return 40;
    }

    @Override
    public float getFriction() {
        return 0.9f;
    }

    @Override
    public float getMovementEasing(float windUp, float distance) {
        return 0.02f + Easing.EXPO_IN.ease(windUp, 0.0f, 0.4f);
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    public SpiritArcanaType getSpiritType() {
        return (SpiritArcanaType)this.getEntityData().get(DATA_SPIRIT_GLOW);
    }

    public void setSpirit(SpiritArcanaType spirit) {
        this.getEntityData().set(DATA_SPIRIT_GLOW, (Object)spirit);
    }
}

