/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.oath.deliverance;

import com.sammy.malum.common.data.attachment.MalignantInfluenceData;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.MalignantCritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;

public class UnsightedResistanceGeas
extends GeasEffect {
    public UnsightedResistanceGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.OATH_OF_UNSIGHTED_RESISTANCE.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("malignant_crit_aegis_rerouting", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("malignant_crit_reduced_damage", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void finalizedMalignantCritEvent(MalignantCritEvent.Post event, LivingEntity attacker) {
        MalignantInfluenceData data = (MalignantInfluenceData)attacker.getData(MalumAttachmentTypes.MALIGNANT_INFLUENCE);
        if (data.getMalignantAegis() < MalignantInfluenceData.getMalignantAegisCapacity(attacker)) {
            event.setNewDamage(event.getNewDamage() * 0.5f);
            data.recoverAegis(attacker, 1.0);
        }
    }
}

