/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.armor;

import com.sammy.malum.client.cosmetic.ArmorSkinRenderingData;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.item.LodestoneArmorItem;

public abstract class MalumArmorItem
extends LodestoneArmorItem {
    public MalumArmorItem(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, int durabilityFactor, Item.Properties pProperties) {
        super(pMaterial, pType, durabilityFactor, pProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemSkinComponent skin = (ItemSkinComponent)stack.get(MalumDataComponents.APPLIED_ITEM_SKIN);
            if (ArmorSkinRenderingData.ARMOR_RENDERING_DATA.containsKey(skin)) {
                return ArmorSkinRenderingData.ARMOR_RENDERING_DATA.get(skin).getTexture(livingEntity);
            }
        }
        return this.getArmorTexture();
    }

    public abstract ResourceLocation getArmorTexture();
}

