/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.scythe;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;

public class CurioRisingEdgeRing
extends MalumCurioItem {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(0.5f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));

    public CurioRisingEdgeRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("ascension_launch", new Object[0]));
        consumer.accept(ComponentHelper.negativeCurioEffect("lower_ascension_damage", new Object[0]));
    }

    public static void launchEntity(LivingEntity attacker, LivingEntity target) {
        float velocity = 0.5f;
        if (MalumScytheItem.isEnhanced(attacker)) {
            velocity += 0.3f;
        }
        attacker.level().explode((Entity)attacker, null, EXPLOSION_DAMAGE_CALCULATOR, target.position().x(), target.position().y(), target.position().z(), 1.2f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST, (ParticleOptions)ParticleTypes.GUST, MalumSoundEvents.SCYTHE_ASCENSION_LAUNCH);
        target.setDeltaMovement(target.getDeltaMovement().add(0.0, (double)velocity, 0.0));
    }
}

