/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioGrowingFleshRing
extends MalumCurioItem
implements IVoidItem,
IMalumEventResponder {
    public CurioGrowingFleshRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("spirits_add_health", new Object[0]));
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        DeferredHolder<MobEffect, MobEffect> cancerousGrowth = MalumMobEffects.CANCEROUS_GROWTH;
        MobEffectInstance effect = collector.getEffect(cancerousGrowth);
        int addedDuration = (int)(150.0 * arcaneResonance);
        if (effect == null) {
            collector.addEffect(new MobEffectInstance(cancerousGrowth, addedDuration * 4, 0, true, true, true));
        } else {
            EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)collector, (int)addedDuration, (int)72000);
            EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)collector, (int)1, (int)19);
        }
        collector.playSound((SoundEvent)MalumSoundEvents.FLESH_RING_ABSORBS.get(), 0.3f, RandomHelper.randomBetween((RandomSource)collector.getRandom(), (float)1.5f, (float)2.0f));
    }
}

