/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.pouch;

import com.sammy.malum.common.data.component.pouch.MalumPouchContentsComponent;
import com.sammy.malum.common.data.component.pouch.SoulwovenPouchContentsComponent;
import com.sammy.malum.common.item.curiosities.pouch.MalumPouchItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

public class SoulwovenPouchItem
extends MalumPouchItem {
    public SoulwovenPouchItem(Item.Properties properties) {
        super(properties.component(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY));
    }

    public static float getFullnessDisplay(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return contents.weight().floatValue();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add(ComponentHelper.positivePouchEffect("soulwoven_pouch_collection", new Object[0]));
        tooltipComponents.add(ComponentHelper.positivePouchEffect("soulwoven_pouch_storage", new Object[0]));
    }

    @Override
    public MalumPouchContentsComponent getContents(ItemStack stack) {
        return (MalumPouchContentsComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
    }

    @Override
    public MalumPouchContentsComponent emptyContents() {
        return SoulwovenPouchContentsComponent.EMPTY;
    }

    @Override
    public void setContents(ItemStack stack, MalumPouchContentsComponent contents) {
        stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)((SoulwovenPouchContentsComponent)contents));
    }

    public static void trySwallowItem(ItemEntityPickupEvent.Pre event) {
        if (event.canPickup().isFalse()) {
            return;
        }
        ItemEntity itemEntity = event.getItemEntity();
        if (itemEntity.hasPickUpDelay()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack pickedUp = itemEntity.getItem();
        if (!pickedUp.is(MalumTags.ItemTags.SOULWOVEN_POUCH_AUTOCOLLECT)) {
            return;
        }
        for (NonNullList playerInventory : player.getInventory().compartments) {
            for (ItemStack item : playerInventory) {
                if (!item.has(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS) || player.getCooldowns().isOnCooldown(item.getItem())) continue;
                SoulwovenPouchItem.trySwallowItem(player, item, pickedUp);
            }
        }
    }

    public static void trySwallowItem(Player player, ItemStack stack, ItemStack pickedUp) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            Item item;
            SoulwovenPouchContentsComponent.Mutable mutable = new SoulwovenPouchContentsComponent.Mutable(contents);
            int i = mutable.tryInsert(pickedUp);
            if (i > 0 && (item = stack.getItem()) instanceof SoulwovenPouchItem) {
                SoulwovenPouchItem pouch = (SoulwovenPouchItem)item;
                pouch.playInsertSound((Entity)player);
            }
            stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)mutable.immutable());
        }
    }
}

