/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.scythe;

import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.core.handlers.enchantment.AscensionHandler;
import com.sammy.malum.core.handlers.enchantment.ReboundHandler;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.item.LodestoneCombatItem;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;

public class MalumScytheItem
extends LodestoneCombatItem
implements IMalumEventResponder {
    public MalumScytheItem(Tier tier, float attackDamage, float attackSpeed, LodestoneItemProperties properties) {
        super(tier, attackDamage + 3.0f, attackSpeed - 3.2f, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (EnchantmentKeys.getEnchantmentLevel(level, EnchantmentKeys.REBOUND, stack) > 0) {
            ReboundHandler.throwScythe(level, player, hand, stack);
            return InteractionResultHolder.success((Object)stack);
        }
        if (EnchantmentKeys.getEnchantmentLevel(level, EnchantmentKeys.ASCENSION, stack) > 0) {
            AscensionHandler.triggerAscension(level, player, hand, stack);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!event.getSource().is(MalumDamageTypes.SCYTHE_MELEE)) {
            return;
        }
        WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).color(stack.getItem()).upwardOffset(-0.4f).forwardOffset(0.8f);
        if (!MalumScytheItem.canSweep(attacker)) {
            SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)this.getScytheSound(false).value()), (float)1.0f, (float)0.75f);
            particle.verticalSlashRotation().horizontalOffset(0.6f).spawn(serverLevel);
            return;
        }
        SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)this.getScytheSound(true).value()), (float)1.0f, (float)1.0f);
        particle.mirroredRandomly(attacker.getRandom()).spawn(serverLevel);
        MalumScytheItem.trySweep(attacker, target, event.getNewDamage());
    }

    public Holder<SoundEvent> getScytheSound(boolean canSweep) {
        return canSweep ? MalumSoundEvents.SCYTHE_SWEEP : MalumSoundEvents.SCYTHE_CUT;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.SWEEPING_EDGE)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public static void trySweep(LivingEntity attacker, LivingEntity target, float baseDamage) {
        Level level = attacker.level();
        AttributeInstance sweeping = attacker.getAttribute(Attributes.SWEEPING_DAMAGE_RATIO);
        if (sweeping != null) {
            float sweepingRatio = (float)sweeping.getValue();
            float damage = baseDamage * (0.5f + sweepingRatio * 0.33f);
            float radius = 1.0f + sweepingRatio * 0.25f;
            level.getEntities((Entity)attacker, target.getBoundingBox().inflate((double)radius)).forEach(e -> {
                LivingEntity sweepTarget;
                if (e instanceof LivingEntity && (sweepTarget = (LivingEntity)e).isAlive() && sweepTarget != target) {
                    sweepTarget.hurt(DamageTypeHelper.create((Level)level, MalumDamageTypes.SCYTHE_SWEEP, (Entity)attacker), damage);
                    sweepTarget.knockback((double)0.4f, (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
                }
            });
        }
    }

    public static ScytheDamage getScytheDamage(DamageSource source, LivingEntity attacker) {
        float magicDamage;
        float physicalDamage;
        boolean isBoomerang = false;
        Entity entity = source.getDirectEntity();
        if (entity instanceof ScytheBoomerangEntity) {
            ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity;
            physicalDamage = scytheBoomerang.damage;
            magicDamage = scytheBoomerang.magicDamage;
            isBoomerang = true;
        } else {
            physicalDamage = (float)attacker.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            magicDamage = (float)attacker.getAttribute((Holder)LodestoneAttributes.MAGIC_DAMAGE).getValue();
        }
        return new ScytheDamage(physicalDamage, magicDamage, isBoomerang);
    }

    public static boolean canSweep(LivingEntity attacker) {
        return !MalumScytheItem.isEnhanced(attacker) && !CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)MalumItems.NECKLACE_OF_THE_HIDDEN_BLADE.get()));
    }

    public static boolean isEnhanced(LivingEntity attacker) {
        return CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)MalumItems.NECKLACE_OF_THE_NARROW_EDGE.get()));
    }

    public static DamageSource replaceDamageSource(Player player, DamageSource source) {
        if (player.getMainHandItem().is(MalumTags.ItemTags.SCYTHES)) {
            return DamageTypeHelper.create((Level)player.level(), MalumDamageTypes.SCYTHE_MELEE, (Entity)player);
        }
        return source;
    }

    public record ScytheDamage(float physicalDamage, float magicDamage, boolean isBoomerang) {
    }
}

