/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class RuneworkingRecipe
extends LodestoneInWorldRecipe<RunicWorkbenchRecipeInput> {
    public static final MapCodec<RuneworkingRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(recipe -> recipe.input), (App)SizedIngredient.FLAT_CODEC.fieldOf("secondaryInput").forGetter(recipe -> recipe.secondaryInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("soundType").forGetter(recipe -> recipe.soundType)).apply((Applicative)obj, RuneworkingRecipe::new));
    public static final String NAME = "runeworking";
    public final SizedIngredient input;
    public final SizedIngredient secondaryInput;
    public final SoundEvent soundType;

    public RuneworkingRecipe(SizedIngredient input, SizedIngredient secondaryInput, ItemStack output, SoundEvent soundType) {
        super((RecipeSerializer)MalumRecipeSerializers.RUNEWORKING_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.RUNEWORKING.get(), output);
        this.input = input;
        this.secondaryInput = secondaryInput;
        this.soundType = soundType;
    }

    public boolean matches(RunicWorkbenchRecipeInput input, Level level) {
        return input.test(this.input, this.secondaryInput);
    }

    public record RunicWorkbenchRecipeInput(ItemStack primaryInput, ItemStack secondaryInput) implements RecipeInput
    {
        public boolean test(SizedIngredient primaryInput, SizedIngredient secondaryInput) {
            return primaryInput.test(this.primaryInput) && secondaryInput.test(this.secondaryInput);
        }

        public ItemStack getItem(int index) {
            return index == 0 ? this.primaryInput : this.secondaryInput;
        }

        public int size() {
            return 2;
        }
    }
}

