/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.node_cooking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.recipe.node_cooking.INodeCookingRecipe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class NodeCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    public final int defaultCookingTime;
    public final Factory<T> factory;
    public final MapCodec<T> codec;
    public final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public NodeCookingSerializer(Factory<T> pFactory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = pFactory;
        this.codec = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Codec.STRING.fieldOf("group").forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getGroup()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(rec$ -> ((INodeCookingRecipe)rec$).getInput()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("output").forGetter(rec$ -> ((INodeCookingRecipe)rec$).getRawOutput()), (App)Codec.INT.fieldOf("outputCount").forGetter(rec$ -> ((INodeCookingRecipe)rec$).getOutputCount()), (App)Codec.FLOAT.fieldOf("experience").forGetter(rec$ -> Float.valueOf(((AbstractCookingRecipe)rec$).getExperience())), (App)Codec.INT.fieldOf("cookingTime").forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getCookingTime())).apply((Applicative)obj, this.factory::create));
        this.streamCodec = StreamCodec.of((x$0, x$1) -> this.toNetwork((RegistryFriendlyByteBuf)x$0, (Object)((AbstractCookingRecipe)x$1)), this::fromNetwork);
    }

    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        Ingredient result = Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer)});
        int outputCount = buffer.readInt();
        float xp = buffer.readFloat();
        int ctime = buffer.readInt();
        return this.factory.create(group, ingredient, result, outputCount, xp, ctime);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, T pRecipe) {
        buffer.writeUtf(pRecipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((INodeCookingRecipe)pRecipe).getInput());
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)((INodeCookingRecipe)pRecipe).getOutput());
        buffer.writeInt(((INodeCookingRecipe)pRecipe).getOutputCount());
        buffer.writeFloat(pRecipe.getExperience());
        buffer.writeInt(pRecipe.getCookingTime());
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public static ItemStack getStackFromIngredient(Ingredient ingredient) {
        ItemStack[] items = ingredient.getItems();
        Optional<ItemStack> stack = Arrays.stream(items).min(Comparator.comparing(c -> c.getItem().getDescriptionId()));
        return stack.orElse(new ItemStack((ItemLike)Items.BARRIER));
    }

    public static interface Factory<T extends AbstractCookingRecipe> {
        public T create(String var1, Ingredient var2, Ingredient var3, int var4, float var5, int var6);
    }
}

