/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.aqueous;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.RandomHelper;

public class DripstoneFluidExtractionRiteEffect
extends SpiritRiteBlockEffect {
    public DripstoneFluidExtractionRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        if (state.is(BlockTags.CAULDRONS)) {
            BlockPos.MutableBlockPos mutable = pos.mutable();
            boolean foundDripstone = false;
            for (int i = 0; i < 8; ++i) {
                mutable.move(Direction.UP);
                BlockState dripstoneState = level.getBlockState((BlockPos)mutable);
                if (!(dripstoneState.getBlock() instanceof PointedDripstoneBlock)) continue;
                foundDripstone = true;
                int tickCount = Mth.floor((float)impact);
                for (int j = 0; j < tickCount; ++j) {
                    dripstoneState.randomTick(level, (BlockPos)mutable, level.random);
                }
            }
            if (foundDripstone) {
                this.createEffect(level, MalumParticleEffectTypes.BLOCK_INFUSION_RITE_EFFECT, pos, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT);
                level.playSound(null, pos, (SoundEvent)MalumSoundEvents.TOTEM_BLOCK_SAP.get(), SoundSource.BLOCKS, 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)0.5f, (float)0.75f));
            }
        }
    }
}

