/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.sacred;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class HealEffect
extends SpiritRiteEntityEffect<LivingEntity> {
    public HealEffect() {
        super(SpiritRiteEffectTag.LESSER_RITE);
    }

    @Override
    public Class<LivingEntity> getTargetClass() {
        return LivingEntity.class;
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, LivingEntity target) {
        if (target.isInvertedHealAndHarm()) {
            return true;
        }
        return target.getHealth() < target.getMaxHealth();
    }

    @Override
    public void applyEffect(ServerLevel level, LivingEntity target) {
        if (target.isInvertedHealAndHarm()) {
            DamageSource damageSource = DamageTypeHelper.create((Level)target.level(), MalumDamageTypes.VOODOO_PLAYERLESS);
            target.hurt(damageSource, 4.0f);
        } else if (target.getHealth() < target.getMaxHealth()) {
            target.heal(4.0f);
        }
        this.createEffect(level, target, MalumSpiritTypes.SACRED_SPIRIT);
    }
}

