/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.worldevent.ActiveBlightWorldEvent;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumWorldEventTypes;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class SuspiciousDeviceTriggerWorldEvent
extends ActiveBlightWorldEvent {
    public SuspiciousDeviceTriggerWorldEvent() {
        super((WorldEventType)MalumWorldEventTypes.SUSPICIOUS_DEVICE_TRIGGER.get());
    }

    @Override
    public void createBlight(ServerLevel level, int intensity) {
        RandomSource random = level.random;
        level.playSound(null, this.position, (SoundEvent)MalumSoundEvents.SUSPICIOUS_DEVICE_DETONATES_AGAIN.get(), SoundSource.BLOCKS, 0.5f, RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.2f));
        Vec3 center = this.position.getCenter().add(SpiritCrucibleCoreBlockEntity.CRUCIBLE_CORE_AUGMENT_OFFSET);
        MalumParticleEffectTypes.ETHERIC_NITRATE_IMPACT.createEffect(center).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT).spawn(level);
        BlockEntity blockEntity = level.getBlockEntity(this.position);
        if (blockEntity instanceof SpiritCrucibleCoreBlockEntity) {
            SpiritCrucibleCoreBlockEntity crucible = (SpiritCrucibleCoreBlockEntity)blockEntity;
            crucible.destroyMultiblock(null, (Level)level, this.position);
            level.destroyBlock(this.position, false);
            level.updateNeighborsAt(this.position, (Block)MalumBlocks.SPIRIT_CRUCIBLE.get());
        }
        level.explode(null, null, null, center.x + (double)RandomHelper.randomBetween((RandomSource)random, (float)-2.0f, (float)2.0f), center.y + (double)RandomHelper.randomBetween((RandomSource)random, (float)-2.0f, (float)2.0f), center.z + (double)RandomHelper.randomBetween((RandomSource)random, (float)-2.0f, (float)2.0f), 1.9f, true, Level.ExplosionInteraction.TNT);
        super.createBlight(level, intensity);
    }
}

