/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.well;

import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.encasement.WeepingWellLayeredBlock;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.worldgen.MalumStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class WeepingWellStructurePiece
extends StructurePiece {
    public static final LodestoneBlockFiller.LodestoneLayerToken WELL = new LodestoneBlockFiller.LodestoneLayerToken();
    private final BlockPos startPos;

    protected WeepingWellStructurePiece(BlockPos startPos, BoundingBox boundingBox) {
        super((StructurePieceType)MalumStructures.StructurePieceTypes.WEEPING_WELL.get(), 0, boundingBox);
        this.startPos = startPos;
    }

    public WeepingWellStructurePiece(CompoundTag tag) {
        super((StructurePieceType)MalumStructures.StructurePieceTypes.WEEPING_WELL.get(), tag);
        this.startPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"startPos").orElseThrow();
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.put("startPos", NbtUtils.writeBlockPos((BlockPos)this.startPos));
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        int i;
        int y;
        int z;
        int x;
        BlockPos wellPosition = this.startPos;
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{WELL});
        LodestoneBlockFiller.LodestoneBlockFillerLayer layer = filler.getLayer(WELL);
        LodestoneBlockFiller.BlockStateEntryBuilder caveAir = LodestoneBlockFiller.create((BlockState)Blocks.CAVE_AIR.defaultBlockState()).setForcePlace();
        LodestoneBlockFiller.BlockStateEntryBuilder primordialSoupTop = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.PRIMORDIAL_SOUP.get()).defaultBlockState()).setForcePlace();
        LodestoneBlockFiller.BlockStateEntryBuilder primordialSoup = LodestoneBlockFiller.create((BlockState)((BlockState)((Block)MalumBlocks.PRIMORDIAL_SOUP.get()).defaultBlockState().setValue((Property)PrimordialSoupBlock.TOP, (Comparable)Boolean.valueOf(false)))).setForcePlace();
        LodestoneBlockFiller.BlockStateEntryBuilder voidConduit = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.VOID_CONDUIT.get()).defaultBlockState()).setForcePlace();
        int airLayer = 3;
        int wellDepth = random.nextInt(8, 12);
        BlockPos.MutableBlockPos mutable = wellPosition.mutable();
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                for (y = 0; y <= airLayer; ++y) {
                    mutable.set((Vec3i)wellPosition).move(x, y, z);
                    layer.put(mutable.immutable(), caveAir);
                }
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                for (y = 0; y <= wellDepth; ++y) {
                    mutable.set((Vec3i)wellPosition).move(x, -y, z);
                    LodestoneBlockFiller.BlockStateEntryBuilder state = caveAir;
                    if (y == 2) {
                        state = x == 0 && z == 0 ? voidConduit : primordialSoupTop;
                    } else if (y > 2) {
                        state = primordialSoup;
                    }
                    layer.put(mutable.immutable(), state);
                }
            }
        }
        LodestoneBlockFiller.BlockStateEntryBuilder flagstoneState = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.WEEPING_WELL_FLAGSTONE.get()).defaultBlockState()).setForcePlace();
        for (i = 0; i < 4; ++i) {
            Direction direction = Direction.from2DDataValue((int)i);
            if (direction.getAxis().equals((Object)Direction.Axis.X)) {
                int j;
                LodestoneBlockFiller.BlockStateEntryBuilder columnBase = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.WEEPING_WELL_COLUMN_BASE.get()).defaultBlockState()).setForcePlace();
                LodestoneBlockFiller.BlockStateEntryBuilder column = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.WEEPING_WELL_COLUMN.get()).defaultBlockState()).setForcePlace();
                LodestoneBlockFiller.BlockStateEntryBuilder columnCap = LodestoneBlockFiller.create((BlockState)((Block)MalumBlocks.WEEPING_WELL_COLUMN_CAP.get()).defaultBlockState()).setForcePlace();
                mutable.set((Vec3i)wellPosition).move(direction, 5);
                int columnHeight = random.nextInt(5, 7);
                for (j = 0; j <= columnHeight; ++j) {
                    LodestoneBlockFiller.BlockStateEntryBuilder state = column;
                    if (j == 0) {
                        state = flagstoneState;
                    } else if (j == 1) {
                        state = columnBase;
                    } else if (j == columnHeight) {
                        state = columnCap;
                    }
                    layer.put(mutable.above(j), state);
                }
                for (j = 0; j < 4; ++j) {
                    Direction columnDirection = Direction.from2DDataValue((int)j);
                    LodestoneBlockFiller.BlockStateEntryBuilder centerState = LodestoneBlockFiller.create((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CENTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection))).setForcePlace();
                    LodestoneBlockFiller.BlockStateEntryBuilder cornerState = LodestoneBlockFiller.create((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CORNER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection))).setForcePlace();
                    BlockPos centerPos = mutable.relative(columnDirection);
                    layer.put(centerPos, centerState);
                    BlockPos cornerPos = centerPos.relative(columnDirection.getClockWise());
                    layer.put(cornerPos, cornerState);
                    for (int k = 0; k < 4; ++k) {
                        int state = Math.min(k + 1, 4);
                        centerState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CENTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state))));
                        cornerState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CORNER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state))));
                        layer.put(centerPos.below(state), centerState);
                        layer.put(cornerPos.below(state), cornerState);
                    }
                }
            }
            for (int j = 0; j <= wellDepth; ++j) {
                int state = Math.min(j, 3);
                if (j == wellDepth) {
                    ++state;
                }
                LodestoneBlockFiller.BlockStateEntryBuilder centerState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CENTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state)))).setForcePlace();
                LodestoneBlockFiller.BlockStateEntryBuilder sideState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_SIDE.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state)))).setForcePlace();
                LodestoneBlockFiller.BlockStateEntryBuilder sideMirroredState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_SIDE_MIRROR.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state)))).setForcePlace();
                LodestoneBlockFiller.BlockStateEntryBuilder cornerState = LodestoneBlockFiller.create((BlockState)((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CORNER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)WeepingWellLayeredBlock.LAYER, (Comparable)Integer.valueOf(state)))).setForcePlace();
                mutable.set((Vec3i)wellPosition).move(direction, 2).setY(wellPosition.getY() - j);
                layer.put(mutable.immutable(), centerState);
                layer.put(mutable.relative(direction.getClockWise()), sideState);
                layer.put(mutable.relative(direction.getCounterClockWise()), sideMirroredState);
                layer.put(mutable.relative(direction.getClockWise(), 2), cornerState);
            }
        }
        for (i = 0; i < 4; ++i) {
            Direction columnDirection = Direction.from2DDataValue((int)i);
            LodestoneBlockFiller.BlockStateEntryBuilder centerState = LodestoneBlockFiller.create((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CENTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection))).setForcePlace();
            LodestoneBlockFiller.BlockStateEntryBuilder cornerState = LodestoneBlockFiller.create((BlockState)((BlockState)((Block)MalumBlocks.WEEPING_WELL_CORNER.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)columnDirection))).setForcePlace();
            BlockPos.MutableBlockPos flagstonePos = mutable.set((Vec3i)wellPosition).move(Direction.DOWN, wellDepth + 1);
            layer.put(flagstonePos.immutable(), flagstoneState);
            BlockPos sidePos = flagstonePos.relative(columnDirection);
            layer.put(sidePos, centerState);
            BlockPos cornerPos = sidePos.relative(columnDirection.getClockWise());
            layer.put(cornerPos, cornerState);
        }
        filler.fill((LevelAccessor)level);
    }
}

