/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;

public interface IArtificeModifierSource {
    public ArtificeModifierSourceInstance createFocusingModifierInstance();

    public Optional<ArtificeModifierSourceInstance> getFocusingModifierInstance();

    default public ArtificeModifierSourceInstance getActiveFocusingModifierInstance() {
        return this.getFocusingModifierInstance().filter(ArtificeModifierSourceInstance::isBound).orElseGet(this::createFocusingModifierInstance);
    }

    default public void triggerRecalibration(Level level, BlockPos pos) {
        this.getFocusingModifierInstance().ifPresent(ArtificeModifierSourceInstance::invalidate);
        Collection nearbyAcceptors = BlockEntityHelper.getBlockEntities(IArtificeAcceptor.class, (Level)level, (BlockPos)pos, (int)6);
        for (IArtificeAcceptor acceptor : nearbyAcceptors) {
            acceptor.recalibrateAccelerators(level);
        }
    }
}

