/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class RegistryCodecBuddy<T> {
    protected final Codec<Holder<T>> holderCodec;
    protected final Codec<T> codec;
    protected final StreamCodec<ByteBuf, T> streamCodec;
    protected final String defaultEntryName;

    public RegistryCodecBuddy(Registry<T> registry, String defaultEntryName) {
        this.holderCodec = registry.holderByNameCodec();
        this.codec = registry.byNameCodec();
        this.streamCodec = ByteBufCodecs.fromCodec(this.codec);
        this.defaultEntryName = defaultEntryName;
    }

    public Codec<Holder<T>> getHolderCodec() {
        return this.holderCodec;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public StreamCodec<ByteBuf, T> getStreamCodec() {
        return this.streamCodec;
    }

    public void save(T entry, CompoundTag tag) {
        this.save(entry, tag, this.defaultEntryName);
    }

    public void save(T entry, CompoundTag tag, String name) {
        tag.put(name, (Tag)this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, entry).getOrThrow());
    }

    public Optional<T> load(CompoundTag tag) {
        return this.load(tag, this.defaultEntryName);
    }

    public Optional<T> load(CompoundTag tag, String name) {
        return this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(name)).map(Pair::getFirst).result();
    }

    public <K extends T> Optional<K> load(CompoundTag tag, Class<K> type) {
        return this.load(tag, type, this.defaultEntryName);
    }

    public <K extends T> Optional<K> load(CompoundTag tag, Class<K> type, String name) {
        return this.load(tag, (T t) -> {
            if (type.isInstance(t)) {
                return type.cast(t);
            }
            return null;
        }, name);
    }

    public <K extends T> Optional<K> load(CompoundTag tag, Function<T, K> mapper) {
        return this.load(tag, mapper, this.defaultEntryName);
    }

    public <K extends T> Optional<K> load(CompoundTag tag, Function<T, K> mapper, String name) {
        return this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(name)).map(Pair::getFirst).result().map(mapper);
    }

    public static interface RegistryCodecBuddyHelper<T> {
        public RegistryCodecBuddy<T> getCodec();

        default public void save(CompoundTag tag) {
            this.getCodec().save(this, tag);
        }

        default public void save(CompoundTag tag, String name) {
            this.getCodec().save(this, tag, name);
        }
    }
}

