/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite.effect;

import com.sammy.malum.common.entity.activator.EntityRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public abstract class SpiritRiteEntityEffect<T extends LivingEntity>
extends SpiritRiteEffect {
    protected SpiritRiteEntityEffect(SpiritRiteEffectTag ... tags) {
        this(Arrays.asList(tags));
    }

    protected SpiritRiteEntityEffect(List<SpiritRiteEffectTag> tags) {
        super(Stream.concat(Stream.of(SpiritRiteEffectTag.RADIAL_EFFECT), tags.stream()).toList());
    }

    @Override
    public boolean triggerRiteEffect(ServerLevel level, BlockPos pos, SpiritArcanaType definingSpirit, SpiritRiteEffect.RiteParameters parameters) {
        List<T> nearbyTargets = this.findNearbyTargets(level, pos);
        if (nearbyTargets.isEmpty()) {
            return false;
        }
        RandomSource random = level.getRandom();
        int totemHeight = parameters.getTotemHeight();
        int counter = 2;
        if (counter > nearbyTargets.size()) {
            counter = nearbyTargets.size();
        }
        Collections.shuffle(nearbyTargets);
        for (int i = 0; i < counter; ++i) {
            LivingEntity target = (LivingEntity)nearbyTargets.get(i);
            UUID uuid = target.getUUID();
            Vec3 position = pos.getCenter().add(0.0, (double)totemHeight, 0.0);
            Vec3 velocity = new Vec3((double)(RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.6f) * (float)(random.nextBoolean() ? 1 : -1)), (double)RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f), (double)(RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.6f) * (float)(random.nextBoolean() ? 1 : -1)));
            EntityRiteEffectActivatorEntity entity = new EntityRiteEffectActivatorEntity((Level)level, this, uuid, position, velocity);
            entity.setSpirit(definingSpirit);
            level.addFreshEntity((Entity)entity);
            SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.SPARK_FORMED.get()), (float)0.5f, (float)Mth.nextFloat((RandomSource)random, (float)0.9f, (float)1.1f));
        }
        return true;
    }

    public abstract Class<T> getTargetClass();

    public void tryApplyEffect(ServerLevel level, LivingEntity target) {
        if (this.getTargetClass().isInstance(target)) {
            this.applyEffect(level, (LivingEntity)this.getTargetClass().cast(target));
        }
    }

    public abstract void applyEffect(ServerLevel var1, T var2);

    public boolean canApplyEffect(ServerLevel level, T target) {
        return true;
    }

    public Holder<SoundEvent> getImpactSound() {
        return MalumSoundEvents.SPARK_IMPACT;
    }

    public float getImpactSoundVolume(LivingEntity target) {
        return 0.4f;
    }

    public int getEffectRange() {
        return 8;
    }

    public List<T> findNearbyTargets(ServerLevel level, BlockPos source) {
        AABB area = new AABB(source).inflate((double)this.getEffectRange());
        return new ArrayList(level.getEntitiesOfClass(this.getTargetClass(), area, e -> {
            Player player;
            if (e instanceof Player && (player = (Player)e).isSpectator()) {
                return false;
            }
            return this.canApplyEffect(level, e);
        }));
    }

    protected void createEffect(ServerLevel level, T target, SpiritLike ... spirits) {
        this.createEffect(level, target, Arrays.asList(spirits));
    }

    protected void createEffect(ServerLevel level, T target, List<? extends SpiritLike> spirits) {
        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)target).color(MalumNetworkedParticleEffectColorData.fromSpirits(spirits)).spawn(level);
    }
}

