/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit.type;

import java.awt.Color;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public record SpiritColorProperties(Color primaryColor, Color secondaryColor, Easing colorEasing, float colorCoefficient, float alphaMultiplier, Color itemColor) {
    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return ColorParticleData.create((Color)this.primaryColor(), (Color)this.secondaryColor()).setCoefficient(this.colorCoefficient() * coefficientMultiplier).setEasing(this.colorEasing());
    }

    public static SpiritTypeColorPropertiesBuilder create(Color primaryColor, Color secondaryColor) {
        return new SpiritTypeColorPropertiesBuilder(primaryColor, secondaryColor);
    }

    public static class SpiritTypeColorPropertiesBuilder {
        public final Color primaryColor;
        public final Color secondaryColor;
        public Easing colorEasing = Easing.LINEAR;
        public float colorCoefficient = 1.0f;
        public float alphaMultiplier = 1.0f;
        public Color itemColor;

        public SpiritTypeColorPropertiesBuilder(Color primaryColor, Color secondaryColor) {
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.itemColor = primaryColor;
        }

        public SpiritTypeColorPropertiesBuilder setColorEasing(Easing colorEasing) {
            this.colorEasing = colorEasing;
            return this;
        }

        public SpiritTypeColorPropertiesBuilder setColorCoefficient(float colorCoefficient) {
            this.colorCoefficient = colorCoefficient;
            return this;
        }

        public SpiritTypeColorPropertiesBuilder setAlphaMultiplier(float alphaMultiplier) {
            this.alphaMultiplier = alphaMultiplier;
            return this;
        }

        public SpiritTypeColorPropertiesBuilder setItemColor(Color itemColor) {
            this.itemColor = itemColor;
            return this;
        }

        public SpiritTypeColorPropertiesBuilder brightenItemColor(int power) {
            this.itemColor = ColorHelper.brighter((Color)this.itemColor, (int)power);
            return this;
        }

        public SpiritTypeColorPropertiesBuilder darkenItemColor(int power) {
            this.itemColor = ColorHelper.darker((Color)this.itemColor, (int)power);
            return this;
        }

        public SpiritColorProperties build() {
            return new SpiritColorProperties(this.primaryColor, this.secondaryColor, this.colorEasing, this.colorCoefficient, this.alphaMultiplier, this.itemColor);
        }
    }
}

