/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder;

import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRecipe;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRegexData;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class SpiritRepairRecipeBuilder
implements LodestoneRecipeBuilder<SpiritRepairRecipe> {
    public final List<Holder<Item>> validItems = new ArrayList<Holder<Item>>();
    public final List<SpiritIngredient> spirits = new ArrayList<SpiritIngredient>();
    public final SizedIngredient repairMaterial;
    public final float repairEfficiency;
    public SpiritRepairRegexData regex = SpiritRepairRegexData.EMPTY;
    public Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public SpiritRepairRecipeBuilder(SizedIngredient repairMaterial, float repairEfficiency) {
        this.repairMaterial = repairMaterial;
        this.repairEfficiency = repairEfficiency;
    }

    public SpiritRepairRecipeBuilder withValidItem(Item item) {
        this.validItems.add((Holder<Item>)item.builtInRegistryHolder());
        return this;
    }

    public SpiritRepairRecipeBuilder addSpirit(SpiritHolder<SpiritArcanaType> spirit, int count) {
        this.spirits.add(new SpiritIngredient((Holder<SpiritArcanaType>)spirit, count));
        return this;
    }

    public SpiritRepairRecipeBuilder withRegex(SpiritRepairRegexData regex) {
        this.regex = regex;
        return this;
    }

    public SpiritRepairRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void tweakAdvancement(Advancement.Builder advancement) {
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
    }

    public SpiritRepairRecipe buildRecipe(ResourceLocation resourceLocation) {
        return new SpiritRepairRecipe(this.validItems, this.spirits, this.repairMaterial, this.repairEfficiency, this.regex);
    }

    public String getRecipeSubfolder() {
        return "spirit_repair";
    }
}

