/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.crafting;

import com.sammy.malum.datagen.recipe.MalumVanillaRecipes;
import com.sammy.malum.datagen.tag.MalumItemTagDatagen;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class MalumWoodSetDatagen
implements IConditionBuilder {
    private static final MalumDatagenWoodSet RUNEWOOD = new MalumDatagenWoodSet("runewood", (Item)MalumItems.RUNEWOOD_LOG.get(), (Item)MalumItems.RUNEWOOD.get(), (Item)MalumItems.STRIPPED_RUNEWOOD_LOG.get(), (Item)MalumItems.STRIPPED_RUNEWOOD.get(), (Item)MalumItems.REVEALED_RUNEWOOD_LOG.get(), (Item)MalumItems.EXPOSED_RUNEWOOD_LOG.get(), (Item)MalumItems.RUNEWOOD_BOARDS.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_BOARDS.get(), (Item)MalumItems.RUNEWOOD_BOARDS_SLAB.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_BOARDS_SLAB.get(), (Item)MalumItems.RUNEWOOD_BOARDS_STAIRS.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_BOARDS_STAIRS.get(), (Item)MalumItems.RUNEWOOD_PLANKS.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_PLANKS.get(), (Item)MalumItems.RUNEWOOD_TILES.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_PLANKS.get(), (Item)MalumItems.VERTICAL_RUSTIC_RUNEWOOD_PLANKS.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_TILES.get(), (Item)MalumItems.RUNEWOOD_PLANKS_SLAB.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_PLANKS_SLAB.get(), (Item)MalumItems.RUNEWOOD_TILES_SLAB.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_PLANKS_SLAB.get(), (Item)MalumItems.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_SLAB.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_TILES_SLAB.get(), (Item)MalumItems.RUNEWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.VERTICAL_RUNEWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.RUNEWOOD_TILES_STAIRS.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.RUSTIC_RUNEWOOD_TILES_STAIRS.get(), (Item)MalumItems.RUNEWOOD_PANEL.get(), (Item)MalumItems.CUT_RUNEWOOD_PLANKS.get(), (Item)MalumItems.RUNEWOOD_BEAM.get(), (Item)MalumItems.RUNEWOOD_BUTTON.get(), (Item)MalumItems.RUNEWOOD_PRESSURE_PLATE.get(), (Item)MalumItems.RUNEWOOD_DOOR.get(), (Item)MalumItems.BOLTED_RUNEWOOD_DOOR.get(), (Item)MalumItems.RUNEWOOD_BOARDS_DOOR.get(), (Item)MalumItems.BOLTED_RUNEWOOD_BOARDS_DOOR.get(), (Item)MalumItems.RUNEWOOD_TRAPDOOR.get(), (Item)MalumItems.BOLTED_RUNEWOOD_TRAPDOOR.get(), (Item)MalumItems.RUNEWOOD_BOARDS_TRAPDOOR.get(), (Item)MalumItems.BOLTED_RUNEWOOD_BOARDS_TRAPDOOR.get(), (Item)MalumItems.RUNEWOOD_FENCE.get(), (Item)MalumItems.RUNEWOOD_FENCE_GATE.get(), (Item)MalumItems.RUNEWOOD_BOARDS_WALL.get(), (Item)MalumItems.RUNEWOOD_SIGN.get(), (Item)MalumItems.RUNEWOOD_SIGN.get(), (Item)MalumItems.RUNEWOOD_ITEM_STAND.get(), (Item)MalumItems.RUNEWOOD_ITEM_PEDESTAL.get(), (Item)MalumItems.GILDED_RUNEWOOD_ITEM_STAND.get(), (Item)MalumItems.GILDED_RUNEWOOD_ITEM_PEDESTAL.get(), MalumTags.ItemTags.RUNEWOOD_LOGS, MalumTags.ItemTags.RUNEWOOD_BOARD_INGREDIENT, MalumTags.ItemTags.RUNEWOOD_PLANKS, MalumTags.ItemTags.RUNEWOOD_BOARDS, MalumTags.ItemTags.RUNEWOOD_STAIRS, MalumTags.ItemTags.RUNEWOOD_SLABS, (Item)MalumItems.RUNEWOOD_BOAT.get(), (Item)MalumItems.RUNEWOOD_CHEST_BOAT.get(), (Item)MalumItems.HALLOWED_GOLD_NUGGET.get());
    private static final MalumDatagenWoodSet SOULWOOD = new MalumDatagenWoodSet("soulwood", (Item)MalumItems.SOULWOOD_LOG.get(), (Item)MalumItems.SOULWOOD.get(), (Item)MalumItems.STRIPPED_SOULWOOD_LOG.get(), (Item)MalumItems.STRIPPED_SOULWOOD.get(), (Item)MalumItems.REVEALED_SOULWOOD_LOG.get(), (Item)MalumItems.EXPOSED_SOULWOOD_LOG.get(), (Item)MalumItems.SOULWOOD_BOARDS.get(), (Item)MalumItems.VERTICAL_SOULWOOD_BOARDS.get(), (Item)MalumItems.SOULWOOD_BOARDS_SLAB.get(), (Item)MalumItems.VERTICAL_SOULWOOD_BOARDS_SLAB.get(), (Item)MalumItems.SOULWOOD_BOARDS_STAIRS.get(), (Item)MalumItems.VERTICAL_SOULWOOD_BOARDS_STAIRS.get(), (Item)MalumItems.SOULWOOD_PLANKS.get(), (Item)MalumItems.VERTICAL_SOULWOOD_PLANKS.get(), (Item)MalumItems.SOULWOOD_TILES.get(), (Item)MalumItems.RUSTIC_SOULWOOD_PLANKS.get(), (Item)MalumItems.VERTICAL_RUSTIC_SOULWOOD_PLANKS.get(), (Item)MalumItems.RUSTIC_SOULWOOD_TILES.get(), (Item)MalumItems.SOULWOOD_PLANKS_SLAB.get(), (Item)MalumItems.VERTICAL_SOULWOOD_PLANKS_SLAB.get(), (Item)MalumItems.SOULWOOD_TILES_SLAB.get(), (Item)MalumItems.RUSTIC_SOULWOOD_PLANKS_SLAB.get(), (Item)MalumItems.VERTICAL_RUSTIC_SOULWOOD_PLANKS_SLAB.get(), (Item)MalumItems.RUSTIC_SOULWOOD_TILES_SLAB.get(), (Item)MalumItems.SOULWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.VERTICAL_SOULWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.SOULWOOD_TILES_STAIRS.get(), (Item)MalumItems.RUSTIC_SOULWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.VERTICAL_RUSTIC_SOULWOOD_PLANKS_STAIRS.get(), (Item)MalumItems.RUSTIC_SOULWOOD_TILES_STAIRS.get(), (Item)MalumItems.SOULWOOD_PANEL.get(), (Item)MalumItems.CUT_SOULWOOD_PLANKS.get(), (Item)MalumItems.SOULWOOD_BEAM.get(), (Item)MalumItems.SOULWOOD_BUTTON.get(), (Item)MalumItems.SOULWOOD_PRESSURE_PLATE.get(), (Item)MalumItems.SOULWOOD_DOOR.get(), (Item)MalumItems.BOLTED_SOULWOOD_DOOR.get(), (Item)MalumItems.SOULWOOD_BOARDS_DOOR.get(), (Item)MalumItems.BOLTED_SOULWOOD_BOARDS_DOOR.get(), (Item)MalumItems.SOULWOOD_TRAPDOOR.get(), (Item)MalumItems.BOLTED_SOULWOOD_TRAPDOOR.get(), (Item)MalumItems.SOULWOOD_BOARDS_TRAPDOOR.get(), (Item)MalumItems.BOLTED_SOULWOOD_BOARDS_TRAPDOOR.get(), (Item)MalumItems.SOULWOOD_FENCE.get(), (Item)MalumItems.SOULWOOD_FENCE_GATE.get(), (Item)MalumItems.SOULWOOD_BOARDS_WALL.get(), (Item)MalumItems.SOULWOOD_SIGN.get(), (Item)MalumItems.SOULWOOD_SIGN.get(), (Item)MalumItems.SOULWOOD_ITEM_STAND.get(), (Item)MalumItems.SOULWOOD_ITEM_PEDESTAL.get(), (Item)MalumItems.ORNATE_SOULWOOD_ITEM_STAND.get(), (Item)MalumItems.ORNATE_SOULWOOD_ITEM_PEDESTAL.get(), MalumTags.ItemTags.SOULWOOD_LOGS, MalumTags.ItemTags.SOULWOOD_BOARD_INGREDIENT, MalumTags.ItemTags.SOULWOOD_PLANKS, MalumTags.ItemTags.SOULWOOD_BOARDS, MalumTags.ItemTags.SOULWOOD_STAIRS, MalumTags.ItemTags.SOULWOOD_SLABS, (Item)MalumItems.SOULWOOD_BOAT.get(), (Item)MalumItems.SOULWOOD_CHEST_BOAT.get(), (Item)MalumItems.SOUL_STAINED_STEEL_NUGGET.get());

    public static void addTags(MalumItemTagDatagen provider) {
        MalumWoodSetDatagen.addTags(provider, RUNEWOOD);
        MalumWoodSetDatagen.addTags(provider, SOULWOOD);
    }

    public static void buildRecipes(RecipeOutput recipeOutput) {
        MalumWoodSetDatagen.buildRecipes(recipeOutput, RUNEWOOD);
        MalumWoodSetDatagen.buildRecipes(recipeOutput, SOULWOOD);
    }

    protected static void addTags(MalumItemTagDatagen provider, MalumDatagenWoodSet woodSet) {
        provider.tag(woodSet.logTag).add((Object[])new Item[]{woodSet.log, woodSet.strippedLog, woodSet.wood, woodSet.strippedWood, woodSet.sapFilledLog, woodSet.strippedSapFilledLog});
        provider.tag(woodSet.boardIngredientTag).add((Object[])new Item[]{woodSet.log, woodSet.wood});
        provider.tag(woodSet.planksTag).add((Object[])new Item[]{woodSet.planks, woodSet.verticalPlanks, woodSet.rusticPlanks, woodSet.verticalRusticPlanks, woodSet.tiles, woodSet.rusticTiles});
        provider.tag(woodSet.boardsTag).add((Object[])new Item[]{woodSet.boards, woodSet.verticalBoards});
        provider.tag(woodSet.stairsTag).add((Object[])new Item[]{woodSet.boardsStairs, woodSet.verticalBoardsStairs, woodSet.planksStairs, woodSet.verticalPlanksStairs, woodSet.rusticPlanksStairs, woodSet.verticalRusticPlanksStairs, woodSet.tilesStairs, woodSet.rusticTilesStairs});
        provider.tag(woodSet.slabTag).add((Object[])new Item[]{woodSet.boardsSlab, woodSet.verticalBoardsSlab, woodSet.planksSlab, woodSet.verticalPlanksSlab, woodSet.rusticPlanksSlab, woodSet.verticalRusticPlanksSlab, woodSet.tilesSlab, woodSet.rusticTilesSlab});
    }

    protected static void buildRecipes(RecipeOutput recipeOutput, MalumDatagenWoodSet woodSet) {
        MalumWoodSetDatagen.shapelessPlanks(recipeOutput, (ItemLike)woodSet.planks, woodSet.logTag);
        MalumWoodSetDatagen.rusticExchange(recipeOutput, (ItemLike)woodSet.rusticPlanks, (ItemLike)woodSet.planks);
        MalumWoodSetDatagen.rusticExchange(recipeOutput, (ItemLike)woodSet.verticalRusticPlanks, (ItemLike)woodSet.verticalPlanks);
        MalumWoodSetDatagen.rusticExchange(recipeOutput, (ItemLike)woodSet.rusticTiles, (ItemLike)woodSet.tiles);
        MalumWoodSetDatagen.shapedBoards(recipeOutput, (ItemLike)woodSet.boards, woodSet.boardIngredientTag);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.boardsSlab, (ItemLike)woodSet.boards);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.boardsStairs, (ItemLike)woodSet.boards);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.verticalBoardsSlab, (ItemLike)woodSet.verticalBoards);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.verticalBoardsStairs, (ItemLike)woodSet.verticalBoards);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.boards, (ItemLike)woodSet.verticalBoards);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.verticalBoards, (ItemLike)woodSet.boards);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.planksSlab, (ItemLike)woodSet.planks);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.planksStairs, (ItemLike)woodSet.planks);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.verticalPlanksSlab, (ItemLike)woodSet.verticalPlanks);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.verticalPlanksStairs, (ItemLike)woodSet.verticalPlanks);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.tilesSlab, (ItemLike)woodSet.tiles);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.tilesStairs, (ItemLike)woodSet.tiles);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.rusticPlanksSlab, (ItemLike)woodSet.rusticPlanks);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.rusticPlanksStairs, (ItemLike)woodSet.rusticPlanks);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.verticalRusticPlanksSlab, (ItemLike)woodSet.verticalRusticPlanks);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.verticalRusticPlanksStairs, (ItemLike)woodSet.verticalRusticPlanks);
        MalumWoodSetDatagen.shapedSlab(recipeOutput, (ItemLike)woodSet.rusticTilesSlab, (ItemLike)woodSet.rusticTiles);
        MalumWoodSetDatagen.shapedStairs(recipeOutput, (ItemLike)woodSet.rusticTilesStairs, (ItemLike)woodSet.rusticTiles);
        MalumWoodSetDatagen.shapelessWood(recipeOutput, (ItemLike)woodSet.wood, (ItemLike)woodSet.log);
        MalumWoodSetDatagen.shapelessWood(recipeOutput, (ItemLike)woodSet.strippedWood, (ItemLike)woodSet.strippedLog);
        MalumWoodSetDatagen.shapelessButton(recipeOutput, (ItemLike)woodSet.button, woodSet.planksTag);
        MalumWoodSetDatagen.shapedPressurePlate(recipeOutput, (ItemLike)woodSet.pressurePlate, woodSet.planksTag);
        MalumWoodSetDatagen.shapedDoor(recipeOutput, (ItemLike)woodSet.door, woodSet.planksTag);
        MalumWoodSetDatagen.shapedDoor(recipeOutput, (ItemLike)woodSet.boardsDoor, woodSet.boardsTag);
        MalumWoodSetDatagen.shapedTrapdoor(recipeOutput, (ItemLike)woodSet.trapdoor, woodSet.planksTag);
        MalumWoodSetDatagen.shapedTrapdoor(recipeOutput, (ItemLike)woodSet.boardsTrapdoor, woodSet.boardsTag);
        MalumWoodSetDatagen.bolting(recipeOutput, (ItemLike)woodSet.boltedDoor, (ItemLike)woodSet.door);
        MalumWoodSetDatagen.bolting(recipeOutput, (ItemLike)woodSet.boltedBoardsDoor, (ItemLike)woodSet.boardsDoor);
        MalumWoodSetDatagen.bolting(recipeOutput, (ItemLike)woodSet.boltedTrapdoor, (ItemLike)woodSet.trapdoor);
        MalumWoodSetDatagen.bolting(recipeOutput, (ItemLike)woodSet.boltedBoardsTrapdoor, (ItemLike)woodSet.boardsTrapdoor);
        MalumWoodSetDatagen.shapedFence(recipeOutput, (ItemLike)woodSet.fence, woodSet.planksTag);
        MalumWoodSetDatagen.shapedFenceGate(recipeOutput, (ItemLike)woodSet.fenceGate, woodSet.planksTag);
        MalumWoodSetDatagen.shapedSign(recipeOutput, (ItemLike)woodSet.sign, woodSet.planksTag);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.planks, (ItemLike)woodSet.verticalPlanks);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.verticalPlanks, (ItemLike)woodSet.tiles);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.tiles, (ItemLike)woodSet.planks);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.rusticPlanks, (ItemLike)woodSet.verticalRusticPlanks);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.verticalRusticPlanks, (ItemLike)woodSet.rusticTiles);
        MalumWoodSetDatagen.planksExchange(recipeOutput, (ItemLike)woodSet.rusticTiles, (ItemLike)woodSet.rusticPlanks);
        MalumWoodSetDatagen.shapedBoat(recipeOutput, (ItemLike)woodSet.boat, woodSet.planksTag);
        MalumWoodSetDatagen.shapedPanel(recipeOutput, (ItemLike)woodSet.panel, woodSet.planksTag);
        Criterion<InventoryChangeTrigger.TriggerInstance> condition = MalumVanillaRecipes.has(woodSet.planksTag);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.boardWall, (int)6).define(Character.valueOf('X'), woodSet.boardsTag).define(Character.valueOf('Y'), (ItemLike)Items.STICK).pattern("XYX").pattern("XYX").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.cutPlanks, (int)2).define(Character.valueOf('X'), (ItemLike)woodSet.panel).define(Character.valueOf('Y'), woodSet.planksTag).pattern("X").pattern("Y").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.beam, (int)3).define(Character.valueOf('#'), woodSet.planksTag).pattern("#").pattern("#").pattern("#").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.itemStand, (int)2).define(Character.valueOf('X'), woodSet.planksTag).define(Character.valueOf('Y'), woodSet.slabTag).pattern("YYY").pattern("XXX").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.itemPedestal).define(Character.valueOf('X'), woodSet.planksTag).define(Character.valueOf('Y'), woodSet.slabTag).pattern("YYY").pattern(" X ").pattern("YYY").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.decoratedItemStand).define(Character.valueOf('X'), (ItemLike)woodSet.itemStand).define(Character.valueOf('Y'), (ItemLike)woodSet.metalNugget).pattern("YXY").unlockedBy("has_input", condition).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)woodSet.decoratedItemPedestal).define(Character.valueOf('X'), (ItemLike)woodSet.itemPedestal).define(Character.valueOf('Y'), (ItemLike)woodSet.metalNugget).pattern("YXY").unlockedBy("has_input", condition).save(recipeOutput);
    }

    private static void bolting(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ResourceLocation recipeID = RecipeBuilder.getDefaultRecipeId((ItemLike)output).withSuffix("_bolting");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).requires(input).requires((ItemLike)Items.IRON_NUGGET).unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput, recipeID);
    }

    private static void planksExchange(RecipeOutput recipeOutput, ItemLike input, ItemLike planks) {
        ResourceLocation recipeID = RecipeBuilder.getDefaultRecipeId((ItemLike)planks).withSuffix("_from_" + RecipeBuilder.getDefaultRecipeId((ItemLike)input).getPath());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)planks, (int)4).define(Character.valueOf('#'), input).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput, recipeID);
    }

    private static void rusticExchange(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ResourceLocation recipeID = RecipeBuilder.getDefaultRecipeId((ItemLike)output).withSuffix("_from_" + RecipeBuilder.getDefaultRecipeId((ItemLike)input).getPath());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)5).define(Character.valueOf('#'), input).pattern(" # ").pattern("###").pattern(" # ").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput, recipeID);
    }

    private static void shapelessPlanks(RecipeOutput recipeOutput, ItemLike planks, TagKey<Item> input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)planks, (int)4).requires(input).group("planks").unlockedBy("has_logs", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedBoards(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)20).define(Character.valueOf('#'), input).pattern(" # ").pattern("###").pattern(" # ").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedPanel(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).define(Character.valueOf('#'), input).pattern("###").pattern("###").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapelessWood(RecipeOutput recipeOutput, ItemLike stripped, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stripped, (int)3).define(Character.valueOf('#'), input).pattern("##").pattern("##").group("bark").unlockedBy("has_log", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapelessButton(RecipeOutput recipeOutput, ItemLike button, TagKey<Item> input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)button).requires(input).unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedDoor(RecipeOutput recipeOutput, ItemLike door, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)door, (int)3).define(Character.valueOf('#'), input).pattern("##").pattern("##").pattern("##").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedFence(RecipeOutput recipeOutput, ItemLike fence, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)fence, (int)3).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), input).pattern("W#W").pattern("W#W").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedFenceGate(RecipeOutput recipeOutput, ItemLike fenceGate, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)fenceGate).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), input).pattern("#W#").pattern("#W#").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedPressurePlate(RecipeOutput recipeOutput, ItemLike pressurePlate, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)pressurePlate).define(Character.valueOf('#'), input).pattern("##").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedSlab(RecipeOutput recipeOutput, ItemLike slab, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)slab, (int)6).define(Character.valueOf('#'), input).pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedStairs(RecipeOutput recipeOutput, ItemLike stairs, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), input).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedTrapdoor(RecipeOutput recipeOutput, ItemLike trapdoor, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)trapdoor, (int)2).define(Character.valueOf('#'), input).pattern("###").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedSign(RecipeOutput recipeOutput, ItemLike sign, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)sign, (int)3).group("sign").define(Character.valueOf('#'), input).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).pattern("###").pattern("###").pattern(" X ").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    private static void shapedBoat(RecipeOutput recipeOutput, ItemLike boat, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)boat).define(Character.valueOf('#'), input).pattern("# #").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
    }

    public record MalumDatagenWoodSet(String prefix, Item log, Item wood, Item strippedLog, Item strippedWood, Item sapFilledLog, Item strippedSapFilledLog, Item boards, Item verticalBoards, Item boardsSlab, Item verticalBoardsSlab, Item boardsStairs, Item verticalBoardsStairs, Item planks, Item verticalPlanks, Item tiles, Item rusticPlanks, Item verticalRusticPlanks, Item rusticTiles, Item planksSlab, Item verticalPlanksSlab, Item tilesSlab, Item rusticPlanksSlab, Item verticalRusticPlanksSlab, Item rusticTilesSlab, Item planksStairs, Item verticalPlanksStairs, Item tilesStairs, Item rusticPlanksStairs, Item verticalRusticPlanksStairs, Item rusticTilesStairs, Item panel, Item cutPlanks, Item beam, Item button, Item pressurePlate, Item door, Item boltedDoor, Item boardsDoor, Item boltedBoardsDoor, Item trapdoor, Item boltedTrapdoor, Item boardsTrapdoor, Item boltedBoardsTrapdoor, Item fence, Item fenceGate, Item boardWall, Item sign, Item hangingSign, Item itemStand, Item itemPedestal, Item decoratedItemStand, Item decoratedItemPedestal, TagKey<Item> logTag, TagKey<Item> boardIngredientTag, TagKey<Item> planksTag, TagKey<Item> boardsTag, TagKey<Item> stairsTag, TagKey<Item> slabTag, Item boat, Item chestBoat, Item metalNugget) {
    }
}

