/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.tag;

import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class MalumGeasTagDatagen
extends IntrinsicHolderTagsProvider<GeasEffectType> {
    public MalumGeasTagDatagen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, MalumGeasEffectTypes.GEAS_TYPES_KEY, lookupProvider, geas -> ((Holder.Reference)MalumGeasEffectTypes.GEAS_TYPES_REGISTRY.getHolder(geas.getRegistryName()).orElseThrow()).getKey(), "malum", existingFileHelper);
    }

    public String getName() {
        return "Malum Geas Tags";
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        HashSet gease = new HashSet(MalumGeasEffectTypes.GEAS_TYPES.getEntries());
        List<DeferredHolder> sorted = gease.stream().sorted(Comparator.comparing(DeferredHolder::getId)).toList();
        for (DeferredHolder holder : sorted) {
            GeasEffectType geas = (GeasEffectType)holder.get();
            geas.getRegistryName();
            ResourceLocation id = holder.getId();
            if (id.getPath().startsWith("oath")) {
                this.tag(MalumTags.GeasTags.IS_OATH).add((Object)geas);
                continue;
            }
            if (id.getPath().startsWith("bond")) {
                this.tag(MalumTags.GeasTags.IS_BOND).add((Object)geas);
                continue;
            }
            if (!id.getPath().startsWith("authority")) continue;
            this.tag(MalumTags.GeasTags.IS_AUTHORITY).add((Object)geas);
        }
        this.tag(MalumTags.GeasTags.HIDDEN_UNTIL_BLACK_CRYSTAL).addTags(new TagKey[]{MalumTags.GeasTags.IS_OATH, MalumTags.GeasTags.IS_AUTHORITY});
    }
}

