/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.sammy.malum.common.geas.authority.GleefulTargetAuthority;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffectInstance.class})
public class MobEffectInstanceMixin {
    @Unique
    private boolean malum$isGleefulTargetActive;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void malum$cacheEntity(LivingEntity entity, Runnable onExpirationRunnable, CallbackInfoReturnable<Boolean> cir) {
        if (entity != null) {
            MobEffectInstance instance = (MobEffectInstance)this;
            if (this.malum$isGleefulTargetActive && entity.level().getGameTime() % 10L != 0L) {
                return;
            }
            this.malum$isGleefulTargetActive = GleefulTargetAuthority.pausePotionEffects(entity, instance);
        }
    }

    @Inject(method={"tickDownDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void malum$pauseEffectDuration(CallbackInfoReturnable<Integer> cir) {
        if (this.malum$isGleefulTargetActive) {
            MobEffectInstance instance = (MobEffectInstance)this;
            cir.setReturnValue((Object)instance.getDuration());
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffect;shouldApplyEffectTickThisTick(II)Z")})
    private boolean malum$preventEffectTicking(MobEffect instance, int duration, int amplifier, Operation<Boolean> original) {
        if (this.malum$isGleefulTargetActive) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance, duration, amplifier});
    }
}

